/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   IOWidget.h

   Obsahuje definici casti GUI pro rizeni animace

   ========================================================================*/

#ifndef IOWIDGET_H
#define IOWIDGET_H

#include <qwidget.h>


#define MAX_RANGE 10000

class QSlider;
class QLCDNumber;
class QLabel;
class QPushButton;

//trida spojujici LCD displej se sliderem + definice prislusnych signalu/slotu
//slouzi pro nastaveni pozice v animaci + ukazatel aktualni pozice

class LCDRange : public QWidget
{
  Q_OBJECT

  int status; // stav komponenty

public:
  LCDRange( QWidget *parent=0, const char *name=0 );

  int value();

public slots:
    void setValue( int );
    void setRange( int minVal, int maxVal );

    void setTime(float f); //meni zobrazeny cas podle prehravani
    void ChangeTime( int );

signals:
    void valueChanged( int );
    void GoTo(float f);

private:

    QSlider     *slider;
    QLCDNumber  *lcd;


};


//***********************************************************************

//trida pro nastaveni rychlosti prehravani animace

class SpeedControl : public QWidget
{
  Q_OBJECT

  float speed; //rychost prehravani

public:
  SpeedControl( QWidget *parent=0, const char *name=0 );

  QPushButton *up;
  QPushButton *down;

  QLCDNumber *lcd;

  QLabel *label;

public slots:

  //nastavi rychlost prehravani na dvojnasobek - zasle signal scheduleru
  //max na 16-ti nasobek
  void SpeedUp();

  //nastavi rychlost prehravani na dvojnasobek - zasle signal scheduleru
  //max na 1/16-inu
  void SpeedDown();


signals:
  void SetSpeed(float);

};


#endif

