/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    
   ServerWidget.cpp
   Trida definujici GUI pro server
   ========================================================================*/

#include "ServerWidget.h"
#include <qpushbutton.h>
#include <qapplication.h>
#include <qfont.h>
#include <qlayout.h>
#include <qpopupmenu.h>
#include <qmenubar.h>
#include <qtextedit.h>
#include <qfiledialog.h>
#include <iostream>

using namespace std;


ServerWidget::ServerWidget(int argc,char** argv,QWidget *parent,const char *name)
	    : QWidget(parent,name)
{

  int port_num;
  int next_option;
  
  textWidget = new QTextEdit("",".",this,"textWidget");
  textWidget->setReadOnly(true);
  textWidget->insert("Server spusten.\n");
  textWidget->insert("Cekam na pripojeni klientu.\n");



  //zpracovani parametru programu
  do {
    next_option = getopt_long(argc,argv,short_options,long_options,NULL);

    switch (next_option)
    {
      case 'h' : //vypise napovedu
        print_usage(0);
	break;

      case 'p' : //spusti server na specifikovanem portu
        port_num = atoi(optarg);
	break;

      case 'f' :
        file_name = optarg;
	break;

      case '?' : //cokoli jineho
        print_usage(1);
	break;
     }
   } while (next_option != -1);


  s = new Server();

  //vytvori noveho klienta, ktery bude cist vstupni data ze souboru
  if (strlen(file_name.c_str()) > 0)
  {
    c = new Socket((char*)file_name.c_str(),true);

    string str = "Novy klient nacten ze souboru \"";
    str += file_name.c_str();
    str += "\"\n";
    textWidget->insert(str.c_str());

    s->NewClient(c);
  }

  QGridLayout *grid = new QGridLayout( this, 3, 6, 10 );



  //definice menu

    QMenuBar *mainMenu = new QMenuBar(this);
    QPopupMenu *file = new QPopupMenu;
    file->insertItem("&Open",  this, SLOT(open()), CTRL+Key_O );
    file->insertSeparator();
    file->insertItem("&Quit",  qApp, SLOT(quit()), CTRL+Key_Q );
    mainMenu->insertItem( "File", file );


  grid->addMultiCellWidget( textWidget, 1, 5, 0, 5 );

  connect(s,SIGNAL(message(QString)), this, SLOT(message(QString)) );

  //spusteni serveru pro vytvareni novych klientu
  s->start();

}

//*******************************************************************************

void ServerWidget::print_usage(int exit_code)
{
  cout << "Pouziti programu: server [options] -f [input files]" << endl;
  cout << "options :    " << endl;
  cout << "	-p num 		--port num   specifikuje cislo portu pro naslouchani"<<endl;
  cout << "	-h 		--help	     zobrazi tuto informaci a skonci" << endl;
  cout << "	-f name		--file name  vstupni data cte ze souboru" << endl;

  exit(exit_code);
}

//*******************************************************************************

bool ServerWidget::open()
{
    QString fname = QFileDialog::getOpenFileName( "/home",
                                              "XML soubory (*.xml)",
                                              this,
                                              "open file dialog"
                                              "Choose a file" );




    //cerr << fname.latin1() << fname.length() << endl;

    if (fname.length() > 0)
    {
      string str = "Novy klient nacten ze souboru \"";
      str = str + fname.latin1();
      str = str + "\"\n";


      c = new Socket((char*)fname.latin1(),true);
      s->NewClient(c);
      textWidget->insert(str.c_str());
    }
    return true;

}

//*******************************************************************************

void ServerWidget::message(QString s)
{
  textWidget->insert(s);
}


//*******************************************************************************

