/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    
   ServerWidget.h
   Trida definujici GUI pro server
   ========================================================================*/

#ifndef SERVERWIDGET_H
#define SERVERWIDGET_H


#include <qlayout.h>
#include <getopt.h>
#include <sstream>
#include "server.h"
#include "client.h"
#include "socket.h"


using namespace std;

class QPushButton;
class QTextEdit;

//definice zkratek parametru programu
const char* const short_options = "hp:f:";

//specifikuje mozne parametry programu
const struct option long_options[] = {
  {"help", 0, NULL, 'h'},
  {"port", 1, NULL, 'p'},
  {"file", 1, NULL, 'f'},
  { NULL , 0, NULL,  0 },
};




class ServerWidget : public QWidget
{
  Q_OBJECT

  Server *s;
  Socket *c;
  ClientWidget *c_w;
  QTextEdit *textWidget;
  

  string file_name; //jmeno vstupniho souboru




public:

  ServerWidget(int argc,char** argv,QWidget *parent = 0,const char *name = 0);

  ~ServerWidget(){delete s;}

  //vypise parametry programu
  void print_usage(int exit_code);
public slots:

  bool open();
  void message(QString s);


};

#endif
