/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   XmlHandler.cpp

   Obsahuje definici tridy MyXmlHandler , ktera zpracovava vstupni xml retezce
   a predava jednotlive atributy a jejich hodnoty k dalsimu zpracovani

   ========================================================================*/


#include <qstring.h>
#include "XmlHandler.h"
#include "parser.h"



MyXmlHandler::MyXmlHandler(parser *p)
{
  pars = p;
}

//******************************************************************************

bool MyXmlHandler::parse(QString s)
{
  //rozdeli retezec na jmeno tagu a atributy a jejich hodnoty
  //pote vola funkci startElement
  int i=0,j=0,l;


  //vynulovani seznamu parametru
  atts.clear();

  l = s.length();

  //odstrani bile znaky ze zacatku a konce retezce a sekvence b.z.  uvnitr retezce
  // na jeden bily znak

  s = s.simplifyWhiteSpace();

  //cout << "Parse" << endl << s << endl;

  //zacatek tagu
  if (s[i++] != '<') return false;

  //jmeno tagu
  while(s[i] !=' ' && s[i] != '>' && i < l)
  {
    i++;
    c = s[i-1];
    bf[j++] = c;
  }
  bf[j] = '\0';

  //posune se za mezeru
  i++;


  //prirazeni jmena tagu
  qname = bf;

  //cout << qname << ":";


  //dokud neni dosazeno konce retezce nebo znaku '>' , '\'
  while (i < (l - 2))
  {
    j=0;
    //jmeno parametru

    while(s[i] != '=' && i < l)
    {
      i++;
      c = s[i-1];
      bf[j++] = c;
    }
    bf[j] = '\0';

    pn = bf;

    //posune se za '='
    i++;
    //posune se za '"'
    i++;

//jednodussi verze
  //  while (s[i++] != '"');

    j=0;
    //hodnota parametru
    while( s[i] !='"' && i < l)
    {
      i++;
      c = s[i-1];
      bf[j++] = c;
    }
    bf[j] = '\0';

    pv = bf;

    //posune se za '"'
    i++;
    //posune se za ' '
    i++;

    //cout << pn << "=" << pv <<" ";

    //atts.append(pn,NULL,NULL,pv);
    atts.append(NULL,NULL,NULL,pv);
  }

  //cout <<endl;
  pars->startElement(NULL,NULL,qname,atts);

  return true;
}


//******************************************************************************

bool MyXmlHandler::parse(char* s)
{
  //rozdeli retezec na jmeno tagu a atributy a jejich hodnoty
  //pote vola funkci startElement
  int i=0,j=0,l;


  //vynulovani seznamu parametru
  atts.clear();

  l = strlen(s);

  //zacatek tagu
  if (s[i++] != '<') return false;

  //jmeno tagu
  while(s[i] !=' ' && s[i] != '>' && i < l)
  {
    i++;
    bf[j++] = s[i-1];
  }
  bf[j] = '\0';

  //posune se za mezeru
  i++;


  //prirazeni jmena tagu
  qname = bf;

  //cout << qname << ":";

  l = strlen(s);

  //dokud neni dosazeno konce retezce nebo znaku '>' , '\'
  while (i < (l - 2))
  {
    j=0;
    //jmeno parametru

    while(s[i] != '=' && i < l)
    {
      i++;
      c = s[i-1];
      bf[j++] = c;
    }
    bf[j] = '\0';

    pn = bf;

    //posune se za '='
    i++;
    //posune se za '"'
    i++;

//jednodussi verze
//    while (s[i++] != '"');

    j=0;
    //hodnota parametru
    while( s[i] !='"' && i<l)
    {
      i++;
      bf[j++] = s[i-1];
    }
    bf[j] = '\0';

    pv = bf;

    //posune se za '"'
    i++;
    //posune se za ' '
    i++;
    //atts.append(pn,NULL,NULL,pv);
    atts.append(NULL,NULL,NULL,pv);
  }

  //cout <<endl;
  pars->startElement(NULL,NULL,qname,atts);

  return true;
}





