/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   client.cpp
   Implementace tridy pro obsluhu klienta
   ========================================================================*/

#include "ServerWidget.h"
#include <qpushbutton.h>
#include <qapplication.h>
#include "client.h"

#include <iostream>
#include <qfont.h>
#include <qapplication.h>
#include <qlabel.h>
#include <qpushbutton.h>
#include <qlcdnumber.h>
#include <qlayout.h>
#include <qlabel.h>
#include <qsocket.h>
#include "GLDrawer.h"

#include "IOWidget.h"
#include "scheduler.h"
#include "parser.h"
#include "dag.h"



ClientWidget::ClientWidget(Socket* sc,QWidget *parent,const char *name) : QWidget(parent,name)
{

  s = sc;


  QPushButton *quit = new QPushButton("&Quit",this,"quit");
  QPushButton *play = new QPushButton("&Play",this,"play");
  //QPushButton *rewplay = new QPushButton("&Rew. Play",this,"rewplay");
  QPushButton *stop = new QPushButton("&Stop",this,"stop");
  QPushButton *pause = new QPushButton("P&ause",this,"pause");


  tree = new dag;  //graf sceny
  drawer = new GLDrawer(this,"drawer",tree); //okno s openGL grafikou
  cs = new command_store;  //fronta prikazu


  p = new parser(cs,tree,sc); //parser
  sch = new scheduler(cs,tree,drawer);//planovac

  status_line = new QLabel("Nacitam animaci...",this);

  //ovladani pozice v animaci
  LCDRange* mpos = new LCDRange(this,"movie_position");
  //ovladani rychlosti animace
  SpeedControl* spc = new SpeedControl(this,"speed_control");


  //propojeni zmeny pozice slideru a planovace
  connect(mpos,SIGNAL(GoTo(float)),sch,SLOT(GoTo(float)) );
  //propojeni zmeny casu v planovaci se sliderem
  connect(sch,SIGNAL(TimeChanged(float)),mpos,SLOT(setTime(float)) );
  //planovac rika GLDraweru, kdy vykreslit dalsi snimek
  connect(sch,SIGNAL(Refresh()),drawer,SLOT(RefreshScreen()) );
  //propojeni rizeni rychlosti animace se schedulerem
  connect(spc,SIGNAL(SetSpeed(float)),sch,SLOT(SetSpeed(float)) );


// Pokud se tyto fonty nenactou drive pred provedenim a.exec v main.cpp , je to problem!

  quit->setFont(QFont("Times",18,QFont::Bold) );
  play->setFont(QFont("Times",18,QFont::Bold) );
  //rewplay->setFont(QFont("Times",18,QFont::Bold) );
  stop->setFont(QFont("Times",18,QFont::Bold) );
  pause->setFont(QFont("Times",18,QFont::Bold) );


  //mrizka pro vkladani objektu
  QGridLayout *grid = new QGridLayout( this, 4, 6, 10 );

  //vlozeni tlacitek a objektu GUI
  grid->addWidget( quit, 2, 0 );
  grid->addWidget( play, 2, 2 );
  //grid->addWidget( rewplay, 2, 3 );
  grid->addWidget( pause,2, 3 );
  grid->addWidget( stop, 2, 4 );


  grid->addMultiCellWidget( mpos, 1, 1, 2, 5 );

  grid->addMultiCellWidget( drawer, 0, 0, 0, 5 );

  grid->addMultiCellWidget( spc, 1, 1, 0, 1 );

  grid->addMultiCellWidget( status_line, 3, 3, 0, 5);

  //grid->setColStretch( 0, 10 );
  grid->setRowStretch( 0, 1000 );

  //spusteni parseru
  p->Start();

  //propojeni tlacitek s odpovidajicimi udalostmi

  connect( play,SIGNAL(clicked()),sch,SLOT(Play()) );
  //connect( rewplay,SIGNAL(clicked()),sch,SLOT(RewPlay()) );
  connect( stop,SIGNAL(clicked()),sch,SLOT(Stop()) );
  connect( pause,SIGNAL(clicked()),sch,SLOT(Pause()) );
  connect( quit,SIGNAL(clicked()),this,SLOT(cQuit()) );



  scan = new QTimer(this,"scan timing");

  connect(scan,SIGNAL(timeout()),SLOT(check()));

  //kazdych 200 ms testuje stav komponent
  scan->start(200);

  status = 0;



}

//******************************************************************************

void ClientWidget::check()
{

  switch (status)
  {
    case 0 : 	if (p->finished())
                {
    		  status_line->setText("Hotovo");
		  status = 1;
		  count = 0;
		  drawer->RefreshScreen();
		}
		break;
    case 1 :	if (count++ > 15)
                {
    		  status_line->setText("");
		  status = 2;
		}
		break;
    default:	break;
  }

}

//******************************************************************************

void ClientWidget::cQuit()
{
  emit clientEnd(this);
}

//******************************************************************************

ClientWidget::~ClientWidget()
{

  delete p;

  delete tree;

  delete cs;

  delete sch;

  delete drawer;
}
//***************************************************************************

