/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    
   dag.h
   Trida definujici ADT pro popis zobrazovane sceny
   ========================================================================*/

#include "dag.h"
#include <iostream>

using namespace std;

tlist::tlist()
//konstruktor seznamu
{
  list = NULL;
  act = NULL;
}


/************************************************************************/

void tlist::gofirst()
//nastavi na prvni prvek v seznamu
{
  if (list != NULL) act = list;
}

/************************************************************************/

int tlist::next()
//posune ukazatel na aktualni prvek na dalsi prvek, pokud je to mozne
{
  if (act != NULL && act->nextn != NULL)
  {
    act = act->nextn;
    return 0;
  }
  else return 1;
}

/************************************************************************/

node* tlist::actual()
//vraci aktualni prvek
{
  return act->data;
}

/************************************************************************/


void tlist::insert(node *co)
{
  //seznam neobsahoval zadne polozky
  if (list == NULL)
  {
    list = new listunit;
    list->data = co;
    list->nextn = NULL;
  }
  //seznam obsahuje aspon jednu polozku
  else
  {
    listunit *pom = list;
    listunit *n = new listunit;
    n->data = co;

    while (pom->nextn != NULL) pom = pom->nextn;

    pom->nextn = n;
    n->nextn = NULL;
  }
}

//********************************************************************

tlist::~tlist()
{
  if (list != NULL)
  {
    listunit *pom = list;
    while (pom -> nextn != NULL)
    {
      pom = pom -> nextn;
      delete list;
      list = pom;
    }
  }
}


//*********************************************************************

dag::dag()
{
  tree = new node("root");  //vytvoreni korene stromu 
}

//**********************************************************************

node* dag::newnode(char *name)
{
  node *pom = new node(name);
  return pom;
}


//**********************************************************************

node* dag::findparent(char *name,node *nd)
{
  static int find = 0;
  static node* goal = NULL;
  node *g = NULL;
  //cout << "findparent*"<<endl;
  if (nd -> branch != NULL)
  {
    //projdi vsechny potomky
    cout << "";
    nd->branch->gofirst();
    do
    {
      if (strcmp(nd->branch->act->data->name,name) == 0)
      //nalezen
      {
	find = 1;
	goal = nd->branch->act->data;
	return goal;
	//cout << "findparent:"<<nd->branch->act->data->name<<endl;
      }
    }
    while((nd->branch->next()) != 1);

    //pokud nenalezl zanori se
    //znovu se nastavil na zacatek seznamu potomku
    nd->branch->gofirst();
    do
    {
      //cout << "findparent***"<<endl;
      g = findparent(name,nd->branch->act->data);
    }
    while (nd->branch->next() != 1);
  }
  if (g != NULL) return goal;
}


//**********************************************************************

int dag::insert(node *syn,char *parent)
{
  if (parent == NULL)
  //vkladame jako naslednika korenoveho uzlu
  {

    if(tree->branch == NULL)

    //seznam potomku korenoveho uzlu je prazdny
    {
      tree->branch = new tlist;
    }

    //vlozeni uzlu jako naslednika korene
    tree->branch->insert(syn);
  }
  else
  {
    //nalezeni uzlu,do nehoz se bude vkladat
    node *parent_node = findparent(parent,tree);
    if (parent_node == NULL)
    {
      //vypis(tree); 
        //cout << "Uzel" << parent << "nenalezen" << endl;
      return 1;
    }
    if (parent_node->branch == NULL)
      parent_node->branch = new tlist;
    parent_node->branch->insert(syn);
  }
  return 0;
}


//*************************************************************************

void dag::zrus_strom(node *nd)
{
  if(nd != NULL)
  {
    if(nd->branch != NULL)
    {
      nd->branch->gofirst();
      do
      {
        zrus_strom(nd->branch->act->data);
      }
      while ((nd->branch->next()) != 1);

      delete nd->branch;
    }
    delete nd;
  }
}

//*************************************************************************

dag::~dag()
{
  zrus_strom(tree);
}

//*************************************************************************

void dag::vypis(node *nd)
{
static int uroven = 0;

  if(nd != NULL)
  {


    if(nd ->branch != NULL)
    {
      uroven++;

      nd->branch->gofirst();
      do
      {
        cout << uroven << nd->branch->act->data->name << endl;
	vypis(nd->branch->act->data);
      }
      while((nd->branch->next()) != 1);
      uroven--;
    }
  }
}


//*************************************************************************

void dag::MakeTree(node *nd)
//projde strom a pro kazdy uzel zavola metodu Make()
{
  if(nd != NULL)
  {


    if(nd ->branch != NULL)
    {
      //projde seznam potomku a pro kazdy vola rekurzivne MakeTree
      nd->branch->gofirst();
      do
      {
        //ulozeni transformacni matice
	//ta se obnovi pri vynoreni se z podstromu
        glPushMatrix();
	nd->branch->act->data->Make();
	MakeTree(nd->branch->act->data);
      }
      while((nd->branch->next()) != 1);
      //obnoveni transformacni matice pro prislusnou uroven v podstromu,
      //tak zachovava ze transformace provedene v prave proslem podstromu
      // neovlivni zadne dalsi uzly
      glPopMatrix();

    }
  }
}



//*************************************************************************

void dag::ResetTree(node *nd)
{
  if(nd != NULL)
  {


    if(nd ->branch != NULL)
    {
      nd->branch->gofirst();
      do
      {
	nd->branch->act->data->reset();
	ResetTree(nd->branch->act->data);

      }
      while((nd->branch->next()) != 1);
    }
  }
}




//*************************************************************************
