/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   dag.h
   Trida definujici ADT pro popis zobrazovane sceny
   ========================================================================*/



#ifndef DAG_H
#define DAG_H
#include <stdlib.h>
#include <iostream>
#include <sstream>

#include <GL/gl.h>
#include <GL/glu.h>
#include <GL/glut.h>




class tlist;
class listunit;


//zakladni typ uzlu, dedi ho vsechny typy uzlu ve scene

class node
{
public:
  int typ;  //znaci typ uzlu - operace / objekt
  int id;   //identifikacni cislo uzlu - mozna ho puziji pro vyhledavani ve stromu
  char *name; //jmeno uzlu - user friendly alternativa k id
  tlist *branch;  //ukazatel seznam potomku,
  		//pokud je roven NULL, jedna se o listovy uzel
 		//potom by melo jit o nejaky objekt
  node()
  {
    name = new char[1];
    branch = NULL;
  }

  node(char *s)
  {
    name = new char[strlen(s) + 1];
    strcpy(name,s);
    branch = NULL;
  }
  virtual ~node() {delete[] name;}

  //tato virtualni funkce je volana pro kazdy uzel pri vykreslovani sceny
  //kazdym uzlem ve scene je dedena od teto zakladni tridy a jsou v ni definovane
  //graficke operace prislusne pro typ uzlu
  virtual void Make(){}
  virtual void reset(){}
};

//************************************************************************

class listunit
{
public:
  listunit *nextn; //ukazatel na dalsi prvek seznamu
  node *data;  //ukazatel na vlastni uzel
};


//*************************************************************************
//deklarace seznamu synu uzlu - obsahuje metody pro manipulaci se seznamem

class tlist
{
public:

  listunit *list;  //ukazatel na prvni prvek seznamu
  listunit *act;   //aktualni prvek v seznamu

  tlist();

  void insert(node* co);  //vlozi ukazatel na synovsky uzel do seznamu

  node* actual();    //vraci ukazatel na aktualni prvek seznamu

  int next();		//posune na dalsi prvek v seznamu,
  			//v pripade neuspechu (konec) vraci 1
  void gofirst();  //nastavi ukazatel na aktualni prvek na zacatek seznamu

  ~tlist();
};

//************************************************************************

//deklarace vlastniho DAG
class dag
{
public:

  node* tree;

  dag();

  int insert(node *syn,char *parent); //vlozi novy uzel jako naslednika uzlu parent

  ~dag();

  //testovaci funkce, vypise obsah stromu
  void vypis(node *nd);
  //projde strom a vykresli ho
  void MakeTree(node *nd);
  //reset stromu , vynuluje atributy operaci , slouzi pro rychly navrat na zacatek animace
  void ResetTree(node *nd);

protected:
  node* newnode(char *name); //pomocna fce pro vytvoreni noveho uzlu

  node* findparent(char *name,node *nd = NULL);  //pomocna funkce pro nalezeni
  //uzlu se jmenem name

  void zrus_strom(node *nd);
  //rekursivni funkce pro zruseni stromu
};

#endif

