/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   parser.cpp

   Obsahuje definici parseru

   ========================================================================*/

#include "parser.h"
#include <qthread.h>
#include <qsocket.h>
#include <qtextstream.h>
#include <qstring.h>
#include <string.h>
#include "GObjects.h"


/******************************************************************/

parser::parser(command_store *_cs,dag *dtree,Socket* c)//:ts(qs)//,src(ts)
{
  server = c; //vytvoreni objektu , serveru ,pro spojeni s klientem
  s = new char[10000];    //buffer pro cteni ze socketu
  name = new char[100];
  parent = new char[100];
  tree = dtree;
  cs = _cs;

  handler = new MyXmlHandler(this);
  reader = new QXmlSimpleReader();
  reader->setContentHandler(this);
  //muze nacitat data
  data_end = false;

}


//****************************************************************

void parser::run()
{

  //tato metoda je spustena jako samostatne vlakno

  QString qs;

  do
  {

    server->Read(s);

    src.setData(s);

    reader->parse(src);


    // handler->parse(qs);

    if (strcmp(s,"</document>")   == 0) data_end = true;

  } while (!data_end);
  
  

}

//***********************************************************************


bool parser::endDocument()
{
  //ukonci cteni dat pri dosazeni konce dokumentu
  //cout << "konec dokumentu" << endl;
  data_end = true;
  return true;
}

//*********************************************************************

bool parser::startElement( const QString&, const QString&, const QString& qname,
           		   const QXmlAttributes& atts)
{


  //vola se funkce provadejici vkladani prikazu do fronty, predaji se XML parametry
  if (qname == "command")
    Command(atts);
  else
  //vola se funkce provadejici vytvareni objektu, predaji se XML parametry
  if (qname == "create")
    Create(atts);
  else
  if (qname == "/document")
    endDocument();

  return false;

}

//*********************************************************************

void parser::Create(const QXmlAttributes& atts)
{
  node_name  	*pom = new node_name;
  node       	*pomnode = NULL;
  //nacteni typu uzlu do pomocne promenne
  QString 	type = atts.value(0);

  //dosazeni jmena uzlu a jeho predka do pomocnych promennych
  strcpy(name,atts.value(1).latin1());
  strcpy(parent,atts.value(2).latin1());

  if (type == "node")
  {
    pomnode = new TNode(name);
    pom->type = TNODE;

  }
  else
  if (type == "sphere")
  {
    pomnode = new Sphere(name);
    pom->type = SPHERE;
  }
    else
  if (type == "cube")
  {
    pomnode = new Cube(name);
    pom->type = CUBE;
  }
  else
  if (type == "polygon")
  {
    int p;
    //zjisteni poctu vrcholu
    p = atoi(atts.value(3));
    point* v = new point[p];



    for(int i=0;i<p;i++)
    {

      v[i].x = atof(atts.value(4+(i*3)));
      v[i].y = atof(atts.value(5+(i*3)));
      v[i].z = atof(atts.value(6+(i*3)));

    }

    pomnode = new Polygon(name,p,v);
    pom->type = POLYGON;
    delete[] v;
  }
  else
  if (type == "line")
  {
    point* v = new point[2];


    for(int i=0;i<2;i++)
    {
      v[i].x = atof(atts.value(3+(i*3)));
      v[i].y = atof(atts.value(4+(i*3)));
      v[i].z = atof(atts.value(5+(i*3)));
    }

    pomnode = new Line(name,v);
    pom->type = LINE;

    delete[] v;
  }
  else
  if (type == "cylinder")
  {

    int r1,r2,h;
    r1 = (int) atof(atts.value(3));
    r2 = (int) atof(atts.value(4));
    h  = (int) atof(atts.value(5));

    pomnode = new Cylinder(name,r1,r2,h);
    pom->type = CYLINDER;


  }
  else
  if (type ==  "pMatrix")
  {
    int x,y,xs,ys,t;
    x = (int) atof(atts.value(3));
    y = (int) atof(atts.value(4));
    xs = (int) atof(atts.value(5));
    ys = (int) atof(atts.value(6));
    t = (int) atof(atts.value(7));

    //volani fce, ktera vytvori sit polygonu
    pomnode = new pMatrix(this,name,parent,x,y,xs,ys,t);
    pom->type = PMATRIX;

  }


  //provede se pro kazdy objekt
  if (strcmp(parent,"NULL") == 0)
  {
    tree->insert(pomnode,NULL);
  }
  else
  {
    tree->insert(pomnode,parent);
  }

  //vytvoreni uzlu

  //vytvoreni odkazu v mape
  pom->name = name;
  pom->ptr = pomnode;

  //prirazeni do mapy
  m[pom->name] = pom;


}

//*********************************************************************

void parser::Command(const QXmlAttributes& atts)
{

  //dosazeni jmena uzlu do pomocne promenne
  strcpy(name,atts.value(0).latin1());


  //pomocna promenna pro prubezne uchovavani dat matice vrcholu
  static point **vertex = NULL;
  //pomocna promenna pro prubezne uchovavani dat matice barev
  static tColor **color = NULL;



  node *pom;
  node_name pom_node,*pom_node2;



  pom_node.name = name;

  //typ prikazu do pomocne promenne pro testovani
  QString type = atts.value(1);


  //zjisteni ukazatele na uzel, kteremu bude zaslan prikaz

  //vyhledani v mape
  pom_node2 = m[name];

  if (pom_node2 == NULL)
  {
    cerr << "Node not found:" <<  pom_node.name << endl;

    return;

  }


  pom = pom_node2 -> ptr;

  command *cd = NULL;


  if (type == "move")
  {

    time = atof(atts.value(2));
    a = atof(atts.value(3));
    b = atof(atts.value(4));
    c = atof(atts.value(5));

    cd = new command(name,MOVE,TNODE,pom,time,a,b,c);
    cs->insert(cd);

  }
  else
  if (type == "moveABS")
  {
    time = atof(atts.value(2));
    a = atof(atts.value(3));
    b = atof(atts.value(4));
    c = atof(atts.value(5));

    cd = new command(name,MOVEABS,TNODE,pom,time,a,b,c);
    cs->insert(cd);

  }
  else
  if (type == "rotate")
  {

    time = atof(atts.value(2));
    ang = atof(atts.value(3));
    a = atof(atts.value(4));
    b = atof(atts.value(5));
    c = atof(atts.value(6));

    cd = new command(name,ROTATE,TNODE,pom,time,a,b,c,ang);
    cs->insert(cd);

  }
  else
  if (type == "setcolor")
  {

    time = atof(atts.value(2));
    a = atof(atts.value(3));
    b = atof(atts.value(4));
    c = atof(atts.value(5));

    cd = new command(name,SETCOLOR,SPHERE,pom,time,a,b,c);
    cs->insert(cd);

  }
  if (type == "setDrawType")
  {

    time = atof(atts.value(2));
    a = atof(atts.value(3));
    b = 0;
    c = 0;

    cd = new command(name,SETDRAWTYPE,SPHERE,pom,time,a,b,c);
    cs->insert(cd);

  }

  else
  if (type == "setradius")
  {

    time = atof(atts.value(2));
    a = atoi(atts.value(3));
    cd = new command(name,SETRADIUS,SPHERE,pom,time,a,b,c);
    cs->insert(cd);

  }
  else
  if (type == "setsize")
  {

    time = atof(atts.value(2));
    a = atof(atts.value(3));

    cd = new command(name,SETSIZE,CUBE,pom,time,a,b,c);
    cs->insert(cd);

  }
  else
  if (type == "setVCoord")
  {
    time = atof(atts.value(2));



    d = atof(atts.value(3));
    a = atof(atts.value(4));
    b = atof(atts.value(5));
    c = atof(atts.value(6));

    cd = new command(name,SETVCOORD,POLYGON,pom,time,a,b,c,d);
    cs->insert(cd);

  }
  else
  if (type == "setLVCoord")
  {
    time = atof(atts.value(2));



    d = atof(atts.value(3));
    a = atof(atts.value(4));
    b = atof(atts.value(5));
    c = atof(atts.value(6));

    cd = new command(name,SETVCOORD,LINE,pom,time,a,b,c,d);
    cs->insert(cd);

  }
  else
  if (type == "setMVCoord")
  {
    string s;
    pMatrix *pm = (pMatrix*) pom;

    time = atof(atts.value(2));

    //data se posilaji po radcich ,pri poslani prvniho radku je nutne provest inicializaci
    if (vertex == NULL)
    {
      vertex = new point*[pm->x+1];
    }

    int r = atoi(atts.value(3));

    vertex[r] = new point[pm->y+1];

    for (int i=0;i<(pm->y+1);i++)
    {
      a = atof(atts.value(4+(i*3) ));
      b = atof(atts.value(5+(i*3) ));
      c = atof(atts.value(6+(i*3) ));

      vertex[r][i].x = a;
      vertex[r][i].y = b;
      vertex[r][i].z = c;

    }

    if (r == (pm->x))
    {
      //po poslani vsech dat se prikaz stava vlastnikem matice dat
      cd = new command(name,SET_PMATRIX_COORD,PMATRIX,pom,vertex,time);

      cs->insert(cd);

      vertex = NULL;
    }
    else return;
  }
  else



  if (type == "setMVColor")
  {
    string s;
    pMatrix *pm = (pMatrix*) pom;

    time = atof(atts.value(2));

    //data se posilaji po radcich ,pri poslani prvniho radku je nutne provest inicializaci
    if (color == NULL)
    {
      color = new tColor*[pm->x];
    }

    int r = atoi(atts.value(3));

    color[r] = new tColor[pm->y];

    for (int i=0;i<pm->y;i++)
    {
      a = atof(atts.value(4+(i*4) ));
      b = atof(atts.value(5+(i*4) ));
      c = atof(atts.value(6+(i*4) ));
      d = atof(atts.value(7+(i*4) ));

      color[r][i].color[0] = a;
      color[r][i].color[1] = b;
      color[r][i].color[2] = c;
      color[r][i].color[3] = d;

    }

    if (r == ((pm->x) - 1))
    {
      //po poslani vsech dat se prikaz stava vlastnikem matice dat
      cd = new command(name,SET_PMATRIX_COLOR,PMATRIX,pom,color,time);

      cs->insert(cd);

      color = NULL;
    }

    else return;
  }




  if (cd->time == 0.0)
  {
    cd->DoCommand();
  }

}

//*********************************************************************


//*********************************************************************


void parser::Start()
{
  //spusti vlakno parseru
  QThread::start();

}

//*********************************************************************

parser::~parser()
{

 typedef map<string,node_name*>::iterator iter_t;
   for(iter_t p=m.begin(); p!=m.end(); ++p)
       delete p->second;

 delete server;
 delete[] s;
 delete[] name;
 delete[] parent;
 delete handler;

}
