/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   parser.h

   Obsahuje definici parseru

   ========================================================================*/

#ifndef PARSER_H
#define PARSER_H

#include <sstream>

#include <qapplication.h>
#include <qthread.h>
#include <qxml.h>
#include <map>
#include <string>
#include "socket.h"
#include "dag.h"
#include "scheduler.h"
#include "GObjects.h"
#include "XmlHandler.h"


using namespace std;

class QSocket;
class QTextStream;

//struktura obalujici jmeno uzlu, a ukazatel na neho, slouzi pro rychle prirazeni
//ukazatele na uzel ke jmenu uzlu pomoci vyhledavani v B-Stromu





class node_name
{
public:
  string name; //jmeno uzlu
  node* ptr;     //ukazatel na prislusny uzel do dag
  int type;      //typ uzlu


  node_name& operator=(const node_name& co)
  {
    name = co.name;
    ptr = co.ptr;
    type = co.type;
    return *this;
  }

  friend bool operator<(const node_name &n1,const node_name &n2);
  friend bool operator<=(const node_name &n1,const node_name &n2);
  friend bool operator==(const node_name &n1,const node_name &n2);
  friend ostream& operator<<(ostream& proud,node_name& co);
};


//**********************************************************************




class parser : public QThread, QXmlDefaultHandler
{
  //objekt umoznujici komunikaci s klientem pomoci socketu
  Socket *server;

  QTextStream 		*text_stream;
  QTextStream 		ts;
  QXmlInputSource 	src;
  QXmlInputSource 	*source;
  QXmlSimpleReader 	*reader;

  char 		*s;
  QString 	qs;
  char 		*name;
  char 		*parent;
  command_store* cs;        //ukazatel na frontu prikazu
  float 	ang,a,b,c,time,d;
  //ukazatel na graf sceny, slouzi pro vkladani objektu z parseru do grafu sceny
public:
  dag 		*tree;

  //mapa slouzici pro rychle vyhledani ukazatelu na uzly v grafu sceny
  map<string,node_name*> m;

  //signalizuje ukonceni nacitani dat od klienta
  bool data_end;

  //custom Xml handler
  MyXmlHandler *handler;

public:
  parser(command_store* _cs,dag *dtree,Socket* c);

  ~parser();

  //spusti cteni ze socketu
  void Start();

  //volana pri zprave create od clienta

  void Create(const QXmlAttributes& atts);

  //volana pri zprave command od klienta

  void Command(const QXmlAttributes& atts);



bool startElement( const QString&, const QString&, const QString& qname,
           		   const QXmlAttributes& atts);
bool endDocument();

bool endElement( const QString&, const QString&, const QString& ){return true;};

protected:

  void run();

};




#endif

