/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   scheduler.cpp

   Obsahuje definici planovace a fronty prikazu

   ========================================================================*/



#include "scheduler.h"
#include <string.h>
#include "GLDrawer.h"



command::command(char *s,operation_types oper,node_types typ,node* trg,float _time,float aa,float bb,float cc,float dd)
{
  name = new char[strlen(s) + 1];
  strcpy(name,s);

  operation = oper;
  target = trg;
  type = typ;
  time = _time;
  a = aa;
  b = bb;
  c = cc;
  oa = 0;
  ob = 0;
  oc = 0;
  ang = dd;


}

//***********************************************************************

command::command(char *s,operation_types oper,node_types typ,node* trg,point **pv,float _time)
{
  name = new char[strlen(s) + 1];
  strcpy(name,s);

  operation = oper;
  target = trg;
  type = typ;
  time = _time;

  vertex = pv; //prirazeni hodnot
  old_vertex = NULL;

}

//***********************************************************************

command::command(char *s,operation_types oper,node_types typ,node* trg,tColor **pc,float _time)
{
  name = new char[strlen(s) + 1];
  strcpy(name,s);

  operation = oper;
  target = trg;
  type = typ;
  time = _time;

  color = pc; //prirazeni hodnot
  old_color = NULL;


}

//***********************************************************************




void command::DoCommand()
{

  if (type == TNODE)
  {
    if (operation == MOVE)
    {

      ((TNode*)target)->move(a,b,c);

    }
    else
    if (operation == MOVEABS)
    {
      oa = ((TNode*)target)->x;
      ob = ((TNode*)target)->y;
      oc = ((TNode*)target)->z;

      ((TNode*)target)->moveABS(a,b,c);

    }
    else
    if (operation == ROTATE)
    {

      ((TNode*)target)->rotate(ang,a,b,c);
    }
  }
  else


  if (type == SPHERE)
  {
    if (operation == SETCOLOR)
    {
      ((Sphere*)target)->SetColor(a,b,c);
    }
    else
    if (operation == SETRADIUS)
    {
      ((Sphere*)target)->SetRadius((int)a);
    }
    else
    if (operation == SETDRAWTYPE)
    {
      ((Sphere*)target)->SetDrawType((int)a);
    }

  }
  else
  if (type == CUBE)
  {
    if (operation == SETCOLOR)
    {
      ((Cube*)target)->SetColor(a,b,c);
    }
    else
    if (operation == SETSIZE)
    {
      ((Cube*)target)->SetSize((int)a);
    }

  }
  else



  if (type == POLYGON)
  {
    if (operation == SETCOLOR)
    {
      ((Polygon*)target)->SetColor(a,b,c);
    }
    else
    if (operation == SETVCOORD)
    {
      ((Polygon*)target)->setVCoord((int)ang,a,b,c);
      oa = a;
      ob = b;
      oc = c;

    }
    else
    if (operation == SETDRAWTYPE)
    {
      ((Polygon*)target)->SetDrawType((int)a);
    }
  }
  else


  if (type == LINE)
  {
    if (operation == SETCOLOR)
    {
      ((Line*)target)->SetColor(a,b,c);
    }
    else
    if (operation == SETVCOORD)
    {
      ((Line*)target)->setVCoord((int)ang,a,b,c);
      oa = a;
      ob = b;
      oc = c;

    }
  }
  else


  if (type == CYLINDER)
  {
    if (operation == SETCOLOR)
    {
      ((Cylinder*)target)->SetColor(a,b,c);
    }
    else
    if (operation == SETDRAWTYPE)
    {
      ((Cylinder*)target)->SetDrawType((int)a);
    }
  }
  else


  if (type == PMATRIX)
  {
    if (operation == SET_PMATRIX_COORD)
    {
      old_vertex = ((pMatrix*)target)->v;
      ((pMatrix*)target)->v = vertex;
    }
    else
    if (operation == SET_PMATRIX_COLOR)
    {
      old_color = ((pMatrix*)target)->colors;
      ((pMatrix*)target)->colors = color;
    }
    else
    if (operation == SETDRAWTYPE)
    {
      ((pMatrix*)target)->SetDrawType((int)a);
    }
  }



}



//***********************************************************************


void command::UndoCommand()
{

  if (type == TNODE)
  {
    if (operation == MOVE)
    {

      ((TNode*)target)->move(-a,-b,-c);

    }
    else
    if (operation == MOVEABS)
    {

      ((TNode*)target)->moveABS(oa,ob,oc);

    }

    else
    if (operation == ROTATE)
    {
      ((TNode*)target)->rotate(-ang,a,b,c);
    }
  }
  else


  if (type == SPHERE)
  {
    if (operation == SETCOLOR)
    {
      ((Sphere*)target)->SetColor(a,b,c);
    }
    else
    if (operation == SETRADIUS)
    {
      ((Sphere*)target)->SetRadius((int)a);
    }
    if (operation == SETDRAWTYPE)
    {
      ((Sphere*)target)->SetDrawType((int)a);
    }
  }
  else


  if (type == CUBE)
  {
    if (operation == SETCOLOR)
    {
      ((Sphere*)target)->SetColor(a,b,c);
    }
    else
    if (operation == SETSIZE)
    {
      ((Cube*)target)->SetSize((int)a);
    }
  }
  else


  if (type == POLYGON)
  {
    if (operation == SETCOLOR)
    {
      ((Polygon*)target)->SetColor(a,b,c);
    }
    else
    if (operation == SETVCOORD)
    {
      ((Polygon*)target)->setVCoord((int)ang,oa,ob,oc);
    }
    else
    if (operation == SETDRAWTYPE)
    {
      ((Polygon*)target)->SetDrawType((int)a);
    }
  }
  else


  if (type == LINE)
  {
    if (operation == SETCOLOR)
    {
      ((Line*)target)->SetColor(a,b,c);
    }
    else
    if (operation == SETVCOORD)
    {
      ((Polygon*)target)->setVCoord((int)ang,oa,ob,oc);
    }
  }
  else


  if (type == CYLINDER)
  {
    if (operation == SETCOLOR)
    {
      ((Cylinder*)target)->SetColor(a,b,c);
    }
    else
    if (operation == SETDRAWTYPE)
    {
      ((Cylinder*)target)->SetDrawType((int)a);
    }
  }


  if (type == PMATRIX)
  {
    if (operation == SET_PMATRIX_COORD)
    {
      if (old_vertex != NULL)
      {

        ((pMatrix*)target)->v = old_vertex;
      }

    }
    else
    if (operation == SET_PMATRIX_COLOR)
    {
      if (old_color != NULL)
      {

        ((pMatrix*)target)->colors = old_color;
      }
    }
    else
    if (operation == SETDRAWTYPE)
    {
      ((pMatrix*)target)->SetDrawType((int)a);
    }
  }
}



//************************************************************************

command_store::command_store()
{
  last = NULL;
  first = NULL;
  act = NULL;

}

//**************************************************************************

void command_store::insert(command* co)

{

  if (first == NULL)
  {
    first = new com_list;
    first->data = co;
    first->next = NULL;
    first->prev = NULL;
    last = first;

  }
  else
  {
    //vlozeni na konec seznamu
    com_list *pom = last;
    com_list *ptr = new com_list;

    ptr->data = co;
    ptr->prev = pom;
    ptr->next = NULL;
    pom->next = ptr;
    last = ptr;
  }
}

//*************************************************************************

int command_store::next()
{
  if (act->next != NULL)
  {

    act = act->next;


    return 0;


  }
  else return 1;
}

//**************************************************************************

int command_store::prev()
{
  if(act->prev != NULL)
  {
    act = act -> prev;
    return 0;
  }
  else return 1;
}

//*************************************************************************

command_store::~command_store()
{
  com_list *pom = first;
  if(first != NULL)
    while(pom->next != NULL)
    {
      first = pom->next;

      delete pom->data;
      delete pom;
      pom = first;
    }


}

//*************************************************************************

scheduler::scheduler(command_store* _cs,dag* dtree,GLDrawer* _gldrawer)
{
  cs = _cs;
  gldrawer = _gldrawer;

  timer = new QTimer(this,"timer");
  steps = 500;
  step = 0;
  time = 0;
  start_time = 0.0;
  end_time = 0.0;
  speed = 1.0; //rychlost nastavena na "normal"
  paused = 0;
  direction = 1;
  tree = dtree;

  connect(timer,SIGNAL(timeout()),this,SLOT(next_frame()) );
}

//*************************************************************************

void scheduler::Play()
{


  if(paused )
  //pokud byla pouze pauza , pokracuj v prehravani
  {
    paused = 0;
    timer->start(1000/SFRAMES);
  }
  else
  //bylo spusteno prehravani v opacnem smeru
  if (direction == 0 && timer->isActive())
  {
    direction = 1;
  }
  else
  {
    if (cs->first == NULL) return;

    step = 0;
    end_time = cs->last->data->time;
    cs->act = cs->first;
    time = cs->first->data->time;

    //po dobu navratu animace do vychoziho bodu zastavi vykreslovani
    timer->stop();
    gldrawer->disableDrawing();

    tree->ResetTree(tree->tree);

    ref_time_div = (end_time - start_time) / (float) steps;

    time_div = ref_time_div * speed;

    timer -> start(1000/SFRAMES);
  }
  direction = 1;
}

//**************************************************************************

void scheduler::RewPlay()
{


  if(paused)
  //pokud byla pouze pauza , pokracuj v prehravani
  {
    paused = 0;
    timer->start(1000/SFRAMES);
  }
  else
  //bylo spusteno prehravani v opacnem smeru
  if (direction == 1 && timer->isActive())
  {
    direction = 0;
  }


  else
  {

  if (cs->first == NULL) return;
    step = 0;
    end_time = cs->last->data->time;
    cs->act = cs->first;
    time = 0.0;

    tree->ResetTree(tree->tree);

    forward(end_time);



    ref_time_div = (end_time - start_time) / (float) steps;
    time_div = ref_time_div * speed;


    timer -> start(1000/SFRAMES);
  }
  direction = 0;
}

//**************************************************************************

void scheduler::next_frame()
{
   gldrawer->disableDrawing();


  //normalni smer
  if (direction == 1)
  {


    while ((cs->act != cs->last) && ((cs->act->data->time) <= time))
    {
      cs->act->data->DoCommand();

      cs->next();
    }


  //pokud dojde na konec fronty , zastavi timer a tim animaci
    if (cs->act == cs->last)
    {
      timer->stop();
    }

    time += time_div;
  }
  else
  //reverzni smer prehravani
  {
    while ((cs->act != cs->first) && (cs->act->data->time) >= time)
    {
      cs->act->data->UndoCommand();

      cs->prev();
    }

  //pokud dojde na konec fronty , zastavi timer a tim animaci
    time -= time_div;
    if (cs->act == cs->first || time <= 0.0)
    {
      timer->stop();
    }


  }

  gldrawer->enableDrawing();
  emit TimeChanged(time/end_time);  //vysle signal s relativni pozici prehravani
  emit Refresh();


}

//*************************************************************************

void scheduler::Stop()
{

  timer->stop();
}

//*************************************************************************

void scheduler::Pause()
{
  //static int paused = 0;
  if (paused)
  {
    timer->start(1000/SFRAMES);
    paused = 0;
  }
  else
  //je mozne zapauzovat pouze, kdyz bezi animace
  if (timer -> isActive())
  {
    paused = 1;
    timer->stop();
  }

}

//*************************************************************************

void scheduler::GoTo(float f)
//posune se na misto v animaci zadane relativni souradnici f
{
  float _time = f * end_time;
  //pokud nebyly nacteny data od klienta , skonci.
  if (cs->first == NULL) return;

  if (_time > time) forward(_time);
  else
  if (_time < time) backward(_time);
}

//***********************************************************************

void scheduler::forward(float ftime)
//posune animaci na cas ftime
{


  while ((cs->act != cs->last) && (cs->act->data->time) <= ftime)
  {
    cs->act->data->DoCommand();

    cs->next();
  }

  time = ftime;

}

//***********************************************************************

void scheduler::backward(float btime)
//posune animaci zpet na cas btime
{


  while ((cs->act != cs->first) && (cs->act->data->time) > btime)
  {
    cs->act->data->UndoCommand();

    cs->prev();
  }

  time = btime;

}

//**********************************************************************

void scheduler::SetSpeed(float f)
{
  //rychlost prehravani zavisi na time_div
  speed = f;
  time_div = ref_time_div * speed;

}
