/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   scheduler.h

   Obsahuje definici planovace a fronty prikazu

   ========================================================================*/


#ifndef SCHEDULER_H
#define SCHEDULER_H


#include <qtimer.h>
#include "GObjects.h"
#include "dag.h"




#define SFRAMES 50


class GLDrawer;

//************************************************************************

//trida command reprezentuje jednotlive prikazy , ktere se provadi pri animaci
class command
{
public:
  char *name;  //jmeno uzlu v popisu sceny, ktery se bude modifikovat
  operation_types operation;  //jmeno operace, ktera se bude provadet
  node_types type;    //typ uzlu
  float ang,a,b,c; //parametry prikazu
  float oa,ob,oc;  //pomocne promenne pro undo
  float time;
  node* target; //pointer na uzel ,se ktery se bude provadet operace

  //parametry prikazu pro praci s maticemi hodnot
  point **vertex;
  tColor **color;
  //pomocne promenne pro undo
  point **old_vertex;
  tColor **old_color;


  command(char *s,operation_types oper,node_types typ,node* trg,float _time = 0.0,float aa = 0.0,float bb = 0.0,float cc = 0.0,float dd = 0.0);
  //prikaz pro zmenu matice vrcholu
  command(char *s,operation_types oper,node_types typ,node* trg,point **pv,float _time = 0.0);
  //prikaz pro zmenu matice barev
  command(char *s,operation_types oper,node_types typ,node* trg,tColor **pc,float _time = 0.0);

  ~command() { delete[] name;}

  void DoCommand();  //provede prikaz
  void UndoCommand();//vrati provedeni prikazu
};


//************************************************************************


class com_list
{
public:
  com_list *next;
  com_list *prev;
  command  *data;
};

//************************************************************************

//trida definujici frontu prikazu, ktera je postupne prochazen pri animaci
class command_store
{
public:

  com_list *first;
  com_list *act;
  com_list *last;

  command_store();
  ~command_store();


  int next();

  int prev();

  void insert(command *co);


};


//************************************************************************

//Trida popisujici planovac, ktery ridi animaci

class scheduler  :  public QObject
{
  Q_OBJECT

public:
  float start_time;
  float end_time;
  float time_div;  //casovy dilek , o ktery se posune animace pri jednom kroku
  float ref_time_div;  //referencni c. d. uchovava puvodni hodnotu
  float time;
  float speed; //rychlost prehravani
  int paused; //indikace , zda je pauza

  dag* tree;  //ukazatel na graf sceny

  int steps;
  int step;
  int direction; //smer prehravani 0 zpetny,1 - normalni



  command_store *cs;

  GLDrawer *gldrawer;

  QTimer *timer;

  scheduler(command_store* _cs,dag* dtree,GLDrawer* _gldrawer);

  ~scheduler(){}

  void forward(float ftime);

  void backward(float btime);

signals:

  void TimeChanged(float);

  void Refresh(); //Posle GLDraweru signal prekresli okno

public slots:

  void Play();

  void RewPlay();

  void Pause();


  void Stop();

  void GoTo(float);

  void SetSpeed(float);



private slots:

  void next_frame();


};

#endif

