/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   server.cpp
   Implementace serveru pro spousteni novych klientu
   ========================================================================*/
   
#include <sstream>
#include <iostream>
#include <qthread.h>
#include <qapplication.h>
#include <qstring.h>
#include "socket.h"
#include "server.h"
#include "client.h"


Server::Server(int port_num)
{
  port = port_num;
  s = new Socket;

  connection_avail = false;

  scan = new QTimer(this,"scan timing");

  connect(scan,SIGNAL(timeout()),SLOT(create()));


  //kazdych 100 ms testuje pripojeni noveho klienta
  scan->start(100);


}


//***************************************************************************

void Server::run()
{

  s->StartListen(port);

  do
  {

    c = s->Accept();
    qs = "Novy klient se pripojil\n";
    message(qs);
    connection_avail = true;

  }
  while (1);
}


//***************************************************************************

void Server::NewClient(Socket* sc)
{
  connection_avail = true;
  c = sc;
}

//***************************************************************************

void Server::Stop(int id)
{
}

//***************************************************************************

Server::~Server()
{
  delete s;
}

//***************************************************************************

void Server::create()
{
  // !!!! Vytvareni novych oken musi byt synchronizovane s QT a X  !!!!
  static bool first = true;

  if (connection_avail)
  {

    ClientWidget *cw = new ClientWidget(c);
    cw->setGeometry(100,100,500,500);
    cw->setCaption("Graphic window");
    cw->show();
    connection_avail = false;
    connect(cw,SIGNAL(clientEnd(ClientWidget*)),this,SLOT(client_quit(ClientWidget*)) );
  }
  else if (first && connection_avail)
  {
    ClientWidget *cw = new ClientWidget(c);
    cw->show();
    delete cw;
    first = false;
    connect(cw,SIGNAL(clientEnd(ClientWidget*)),this,SLOT(client_quit(ClientWidget*)) );
  }
}

//***************************************************************************

void Server::client_quit(ClientWidget* cw)
{
  delete cw;
}

