/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   server.h
   Implementace serveru pro spousteni novych klientu
   ========================================================================*/

#ifndef SERVER_H
#define SERVER_H

#include <qthread.h>
#include <qobject.h>
#include <qtimer.h>
#include "socket.h"
#include "client.h"



//class Socket;
class ClientWidget;
class QString;

class Server : public QObject ,public QThread
{
  Q_OBJECT

  int port;

  bool connection_avail;

  Socket *s;  //ukazatel na socket zachycujici pripadna nova spojeni

  QString qs;

  QTimer *scan;

public:

  Socket *c;  //zachycuje navratovou hodnotu funkce accept, uklada se do neho
  //soket pro komunikaci s klienty


  Server(int port_num = 2048);

  ~Server();

  void NewClient(Socket *sc); //"spusti" noveho klienta

signals:

  void new_client(Socket*);

  void message(QString s);

public slots:

  void Stop(int id);

  void create();

  void client_quit(ClientWidget*);


protected:

  void run();





};

#endif
