/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    
   socket.cpp
   Trida zajistujici obousmerne spojeni klienta a serveru
   ========================================================================*/

#include <iostream>
#include "socket.h"


using namespace std;

Socket::Socket()

{
  count = 0;

  connected = false;

  listening = false;

  from_file = false;

  to_file = false;

  socket_fd = socket(AF_INET, SOCK_STREAM, 0);

}


//**************************************************************************

Socket::Socket(int fd)
//socket vytvoreny funkci accept
{
  count = 0;

  connected = true;

  listening = false;

  from_file = false;

  to_file = false;


  socket_fd = fd;

}

//**************************************************************************

Socket::Socket(char* name,bool io)
//socket vytvoreny funkci accept
{
  //pracuje se souborem - nemusi se pripojovat
  connected = true;

  count = 0;

  listening = false;

  if (io)
  {
    from_file = true;
    to_file = false;

    infile.open(name);

    if (!infile)
    {
      std::cout << "nelze vytvorit soubor" << endl;
      exit(1);
    }


  }
  else
  {
    from_file = false;
    to_file = true;

    outfile.open(name);

    if (!outfile)
    {
      cout << "nelze vytvorit soubor" << endl;
      exit(1);
    }
  }


}

//**************************************************************************


int Socket::Connect(const char* name,int port)
{
  struct hostent *host;

  struct sockaddr_in host_addr;

  int r;


  //is already connected - returns
  if (connected)
  {
    char s[] = "<document>";
    Write(s);
    return 0;
  }


  bzero((char*)&host_addr,sizeof(host_addr)); //nastaveni vsech bytu struktury na 0

  host_addr.sin_family = AF_INET;  //nastaveni typu socketu na internetovy
  host = gethostbyname(name); //prevede adresu cile na ciselny format
  host_addr.sin_addr = *((struct in_addr*) host->h_addr);
  host_addr.sin_port = htons(port);

  //vlastni spojeni - vraci 0 pri uspechu
  r = connect(socket_fd,((struct sockaddr*)&host_addr),sizeof(struct sockaddr_in));
  if (r == 0)
  {
   char s[] = "<document>";
   Write(s);
   connected = true;
  }

  return r;
}

//**************************************************************************

bool Socket::StartListen(int port,int backlog)
//parametr backlog specifikuje maximalni pocet pozadavku cekajicich ve fronte
{

  if (listening) return false;

  //vytvoreni socketu pro naslouchani
  sock = socket(AF_INET, SOCK_STREAM, 0);
//  struct hostent *host;



  struct sockaddr_in addr;

  bzero((char *)&addr, sizeof(addr));
  addr.sin_family = AF_INET;

  addr.sin_addr.s_addr = htonl(INADDR_ANY);

//  host = gethostbyname("localhost"); //prevede adresu cile na ciselny format

//  addr.sin_addr = *((struct in_addr*) host->h_addr);

  addr.sin_port = htons(port);



  bind(sock, (struct sockaddr*)&addr, sizeof(struct sockaddr_in));

  listen(sock, backlog) ;
  listening = true;
  return listening;



}

//**************************************************************************

void Socket::Write(char* buffer)
//zapise retezec do socketu
{
  if(PACKET_COUNT_ENABLE)
  {
    count++;
    cout << count << "#";
    if(count > MAX_PACKETS*110/100)
    {
      Read(buff);
      cout << buff << endl;
      count = 0;
    }


  }

  if (to_file)
  //zapis do souboru
  {
    //zjisti delku retezce
    int length = strlen(buffer) + 1;
    //pridani konce radku
    buffer[length-1] = '\n';
    outfile.write(buffer,length);
  }
  else
  {
  //zjisti delku retezce
  int length = strlen(buffer) + 1;
  //zapise delku retezce do socketu
  write(socket_fd,&length,sizeof(length));
  //zapise vlastni text do socketu
  write(socket_fd,buffer,length);
  }
}

//**************************************************************************

Socket* Socket::Accept()
{

  struct sockaddr addr;

  socklen_t len = sizeof(struct sockaddr);

  int fd = accept(sock, &addr, &len);
  if (fd == -1) return NULL;


  Socket *new_sock = new Socket(fd);
    return new_sock;

}

//**************************************************************************

char* Socket::Read(char* buffer)
//precte retezec ze socketu
{
  if(PACKET_COUNT_ENABLE)
  {
    count++;

    if(count > MAX_PACKETS)
    {
      Write("OK");
      count = 0;
    }
  }

  if (from_file)
  {
    infile.getline(buffer,10000,'\n');
  }
  else
  {
    int length;
    if ( read(socket_fd,&length,sizeof(length)) == 0)
    {
    //client uzavrel spojeni
      return NULL;
    }
    read(socket_fd,buffer,length);

    //close(client_socket_fd);
  }

  return buffer;

}

//**************************************************************************

Socket::~Socket()
{

    close(socket_fd);
}

//**************************************************************************
/*
void Socket::WriteFloat(float f)
{
  if (to_file)
  //zapis do souboru
  {
    outfile.write(&f,sizeof(f));
  }
  else

  write(socket_fd,&f,sizeof(f));
}

// **************************************************************************

float* Socket::ReadFloat(float *f)
{
  if (from_file)
  {
    infile.read(f,sizeof(f));
    return f;
  }
  else
  {
    if ( read(socket_fd,f,sizeof(*f)) == 0)
    return NULL;
    else return f;
  }
}
*/
//**************************************************************************

void Socket::Disconnect(void)
//zasle serveru zpravu o ukonceni spojeni
{
  if (connected == true)
  {
    char st[] = "</document>";
    Write(st);
    connected = false;
  }
}


