/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   socket.h
   Trida zajistujici obousmerne spojeni klienta a serveru

   ========================================================================*/


#ifndef LSOCKET_H
#define LSOCKET_H

#include <stdio.h>
#include <string>
#include <sys/socket.h>
#include <sys/un.h>
#include <unistd.h>

#include <stdarg.h>
#include <fcntl.h>
#include <netdb.h>
#include <errno.h>
#include <netinet/in.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <sys/time.h>
#include <fstream>




#define SOCKET_NAME "/tmp/socket"
#define TO_FILE false
#define FROM_FILE true

using namespace std;

// pocet uskutecnenych zapisu, po kterych se ceka na potvrzeni od klienta
const int MAX_PACKETS = 100;
//povoluje tuto funkci
const int PACKET_COUNT_ENABLE = 0;


class Socket {

public:

  int socket_fd;  //socket file deskriptor

  int count;

  socklen_t client_name_len;
  int mtype;     //rozlisuje client / server
  bool connected;
  int sock; //socket pro naslouchani a akceptovani spojeni
  bool listening;
  bool to_file;  //indikuje, zda ma data zapisovat do soketu(false),
                 //nebo do souboru(true)
  bool from_file;//indikuje, zda se data ctou ze soketu(false) nebo souboru(true)

  ifstream infile; //soubor pro cteni
  ofstream outfile;   //soubor pro zapis
  char buff[50]; //pomocna promenna


public:

  //defaultni konstruktor
  Socket();
  //pro IO pouzije uz vytvoreny fd
  Socket(int fd);
  //pro IO pouzije soubor s jmenem name , druhy parametr rika,zda pujde o
  //vstupni (true) nebo vystupni operace
  Socket(char* name,bool io);

  bool StartListen(int port,int backlog = 10);


  Socket* Accept();

  int Connect(const char* name,int port);

  char* Read(char* buffer);

//  float* ReadFloat(float *f);

//  void WriteFloat(float f);

  void Write(char* buffer);

  void Disconnect(void);  //fce volana bud destruktorem klienta, nebo klientem

  ~Socket();


};

#endif

