/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   visualisation.cpp
   Zde je popis objektu, z kterych je mozne modelovat scenu na strane klienta
   ========================================================================*/


#include "visualisation.h"
#include <string.h>

Socket* VClient::c = NULL;  //nezbytna definice

//******************************************************************************

int VClient::init(int argc,char **argv)
{
  int port_num = 0;
  int next_option;

  string file_name = "";
  string adress;

  //implicitni nastaveni
  if (argc == 1)
  {
    adress = "localhost";
    port_num = 2048;
  }



  //zpracovani parametru programu
  do {
    next_option = getopt_long(argc,argv,short_options,long_options,NULL);

    switch (next_option)
    {
      case 'h' : //vypise napovedu
        print_usage(0);
	break;

      case 'p' : //spusti server na specifikovanem portu
        port_num = atoi(optarg);
	break;

      case 'f' :
        file_name = optarg;
	break;

      case 'a' :
        adress = optarg;
	break;

      case '?' : //cokoli jineho
        print_usage(1);
	break;
     }
   } while (next_option != -1);



   if (file_name.length() > 0)
   {
     c = new Socket((char*)file_name.c_str(),TO_FILE);
   }
   else
   if (adress.length() == 0)
   {
     cout << "Musite zadat adresu serveru" << endl;
     print_usage(1);
   }
   else
   if (port_num == 0)
   {
     cout << "Musite zadat cislo portu" << endl;
     print_usage(1);
   }
   else
   {
      c = new Socket();
      if (c->Connect(adress.c_str(),port_num) != 0)
      {
        cerr << "Nepodarilo se navazat spojeni" << endl;
        exit(2);
      }
   }



  return 0;

}

//******************************************************************************

void VClient::finish()
{
   c->Disconnect();

  delete c;
}

//******************************************************************************

void VClient::print_usage(int exit_code)
{
  cout << "Pouziti programu: jmeno programu [options] -f [outpup file]" << endl;
  cout << "options :    " << endl;
  cout << "	-a num		--adress     adresa serveru" << endl;
  cout << "	-p num 		--port num   cislo portu"<< endl;
  cout << "	-h 		--help	     zobrazi tuto informaci a skonci" << endl;
  cout << "	-f name		--file name  vystupni data uklada do souboru" << endl;

  exit(exit_code);
}


//******************************************************************************

DNode::DNode(char* s,char* parent)
{
  name = new char[strlen(s) + 1];
  strcpy(name,s);

  //vytvoreni zakladniho typu uzlu
  //vystup by mel byt ve tvaru
  // <create type="node" name="name" parent="parent"/>

  b = "<create type=\"node\" name=\"";
  b += name;
  b += "\" parent=\"";
  if (parent == NULL)
    b += "NULL";
  else
    b += parent;
  b += "\"/>";

  //zapis bufferu do socketu
  c->Write((char*)b.c_str());



}

//********************************************************************

void DNode::rotate(float ang,float xa,float ya,float za,float time)
{
  b = "<command adress=\"";
  b += name;
  b += "\" type=\"rotate\" time=\"";
  sprintf(conv,"%f",time);
  b += conv;
  b += "\" angle=\"";
  sprintf(conv,"%f",ang);
  b += conv;
  b += "\" xaxis=\"";
  sprintf(conv,"%f",xa);
  b += conv;
  b += "\" yaxis=\"";
  sprintf(conv,"%f",ya);
  b += conv;
  b += "\" zaxis=\"";
  sprintf(conv,"%f",za);
  b += conv;
  b += "\" />";
  c->Write((char*)b.c_str());
}

//********************************************************************

void DNode::move(float x,float y,float z,float time)
{
  b = "<command adress=\"";
  b += name;
  b += "\" type=\"move\" time=\"";
  sprintf(conv,"%f",time);
  b += conv;
  b += "\" x=\"";
  sprintf(conv,"%f",x);
  b += conv;
  b += "\" y=\"";
  sprintf(conv,"%f",y);
  b += conv;
  b += "\" z=\"";
  sprintf(conv,"%f",z);
  b += conv;
  b += "\" />";
  c->Write((char*)b.c_str());

}

//********************************************************************

void DNode::moveABS(float x,float y,float z,float time)
{
  b = "<command adress=\"";
  b += name;
  b += "\" type=\"moveABS\" time=\"";
  sprintf(conv,"%f",time);
  b += conv;
  b += "\" x=\"";
  sprintf(conv,"%f",x);
  b += conv;
  b += "\" y=\"";
  sprintf(conv,"%f",y);
  b += conv;
  b += "\" z=\"";
  sprintf(conv,"%f",z);
  b += conv;
  b += "\" />";
  c->Write((char*)b.c_str());

}


//********************************************************************

void GElement::setColor(float rr,float gg,float bb,float time)
{
  b = "<command adress=\"";
  b += name;
  b += "\" type=\"setcolor\" time=\"";
  sprintf(conv,"%f",time);
  b += conv;
  b += "\" r=\"";
  sprintf(conv,"%f",rr);
  b += conv;
  b += "\" g=\"";
  sprintf(conv,"%f",gg);
  b += conv;
  b += "\" b=\"";
  sprintf(conv,"%f",bb);
  b += conv;
  b += "\" />";
  c->Write((char*)b.c_str());

}


//********************************************************************

Sphere::Sphere(char *s,char *parent,int radius, int ph,int vh)
{
  name = new char[strlen(s) + 1];
  strcpy(name,s);


  b = "<create type=\"sphere\" name=\"";
  b += name;
  b += "\" parent=\"";
  if (parent == NULL)
    b += "NULL";
  else
    b += parent;
  b += "\" radius=\"";
  sprintf(conv,"%d",radius);
  b += conv;
  b += "\" ph=\"";
  sprintf(conv,"%d",ph);
  b += conv;
  b += "\" vh=\"";
  sprintf(conv,"%d",vh);
  b += conv;


  b += "\"/>";

  //zapis bufferu do socketu
  c->Write((char*)b.c_str());



}

//********************************************************************

void Sphere::setRadius(int radius,float time)
{
 b = "<command adress=\"";
  b += name;
  b += "\" type=\"setradius\" time=\"";
  sprintf(conv,"%f",time);
  b += conv;
  b += "\" radius=\"";
  sprintf(conv,"%d",radius);
  b += conv;
  b += "\"/>";

  //zapis bufferu do socketu
  c->Write((char*)b.c_str());


}


//********************************************************************

Cube::Cube(char *s,char *parent,int size)
{
  name = new char[strlen(s) + 1];
  strcpy(name,s);

  b = "<create type=\"cube\" name=\"";
  b += name;
  b += "\" parent=\"";
  if (parent == NULL)
    b += "NULL";
  else
    b += parent;
  b += "\" size=\"";
  sprintf(conv,"%d",size);
  b += conv;

  b += "\"/>";

  //zapis bufferu do socketu
  c->Write((char*)b.c_str());

}

//********************************************************************

void Cube::setSize(int size,float time)
{
  b = "<command adress=\"";
  b += name;
  b += "\" type=\"setsize\" time=\"";
  sprintf(conv,"%f",time);
  b += conv;
  b += "\" size=\"";
  sprintf(conv,"%d",size);
  b += conv;
  b += "\"/>";

  //zapis bufferu do socketu
  c->Write((char*)b.c_str());

}

//********************************************************************

Polygon::Polygon(char* s,char* parent,int pocet_vrcholu,point* vertex)
{
  name = new char[strlen(s) + 1];
  strcpy(name,s);

  //<create type="polygon" name="name" parent="parent" pocet_vrcholu="x" v1x="x1" v1y="y1" v1z="z1" .../>

  b = "<create type=\"polygon\" name=\"";
  b += name;
  b += "\" parent=\"";
  if (parent == NULL)
    b += "NULL";
  else
    b += parent;
  b += "\" vs_num=\"";
  sprintf(conv,"%d",pocet_vrcholu);
  b += conv;
  b += "\"";

  for(int i=0;i<pocet_vrcholu;i++)
  {

    //!!!     souradnice jsou int???     !!!

    sprintf(conv," v%dx=\"%.4f\"",i,vertex[i].x);
    b += conv;
    sprintf(conv," v%dy=\"%.4f\"",i,vertex[i].y);
    b += conv;
    sprintf(conv," v%dz=\"%.4f\"",i,vertex[i].z);
    b += conv;


  }



  b += "/>";

  //zapis bufferu do socketu
  c->Write((char*)b.c_str());



}

//**********************************************************************************

void Polygon::setVCoord(int cislo_vrcholu,point vertex,float time)
{
  int i;

//<command adress="" type="setVCoord time="" cislo_vrcholu="" v1x="" v1y="" v1z=""/>

  b = "<command adress=\"";
  b += name;
  b += "\" type=\"setVCoord\" time=\"";
  sprintf(conv,"%f",time);
  b += conv;

  b += "\" v_num=\"";
  sprintf(conv,"%d",cislo_vrcholu);
  b += conv;
  b += "\"";

  i = cislo_vrcholu;


    sprintf(conv," v%dx=\"%.4f\"",i,vertex.x);
    b += conv;
    sprintf(conv," v%dy=\"%.4f\"",i,vertex.y);
    b += conv;
    sprintf(conv," v%dz=\"%.4f\"",i,vertex.z);
    b += conv;

/*
  sprintf(conv," v%dx=\"%f\"",i,vertex.x);
  b += conv;
  sprintf(conv," v%dy=\"%f\"",i,vertex.y);
  b += conv;
  sprintf(conv," v%dz=\"%f\"",i,vertex.z);
  b += conv;
*/

  b += "/>";

  //zapis bufferu do socketu
  c->Write((char*)b.c_str());


}

//**********************************************************************************

void Polygon::setMVCoord(int pocet_vrcholu,char **name,int *v_num,point vertex,float time = 0.0)
{

  //nastavi u polygonu urcenych jmeny v parametru name urcene vrcholy na stejnou souradnici
  //cislo vrcholu je urcene hodnotou par ve strukture point
  int i;

//<command adress="" type="setMVCoord time="" pol_num="" pol_id="" vert_num="" v1x="" v1y="" v1z="" .../>

  b = "<command adress=\"\"";
  b += " type=\"setMVCoord\" time=\"";
  sprintf(conv,"%f",time);
  b += conv;
  b += "\" pol_num=\"";
  sprintf(conv,"%d",pocet_vrcholu);
  b += conv;
  b += "\" ";

  for (i=0;i<pocet_vrcholu;i++)
  {
    b += "pol_id=\"";
    b += name[i];

    b += "\" v_num=\"";
    sprintf(conv,"%d",v_num[i]);
    b += conv;
    b += "\"";


    sprintf(conv," v%dx=\"%.4f\"",i,vertex.x);
    b += conv;
    sprintf(conv," v%dy=\"%.4f\"",i,vertex.y);
    b += conv;
    sprintf(conv," v%dz=\"%.4f\"",i,vertex.z);
    b += conv;
  }

  b += "/>";

  //zapis bufferu do socketu
  c->Write((char*)b.c_str());


}


//**********************************************************************************

Line::Line(char* s,char* parent,point* vertex)
{

  name = new char[strlen(s) + 1];
  strcpy(name,s);

  b = "<create type=\"line\" name=\"";
  b += name;
  b += "\" parent=\"";
  if (parent == NULL)
    b += "NULL";
  else
    b += parent;
  b += "\"";

  for(int i=0;i<2;i++)
  {

    sprintf(conv," v%dx=\"%f\"",i,vertex[i].x);
    b += conv;
    sprintf(conv," v%dy=\"%f\"",i,vertex[i].y);
    b += conv;
    sprintf(conv," v%dz=\"%f\"",i,vertex[i].z);
    b += conv;

  }

  b += "/>";

  //zapis bufferu do socketu
  c->Write((char*)b.c_str());




}



//***********************************************************************************

void Line::setVCoord(int cislo_vrcholu,point vertex,float time)
{
  int i;

//<command adress="" type="setLVCoord time="" cislo_vrcholu="" v1x="" v1y="" v1z=""/>

  b = "<command adress=\"";
  b += name;
  b += "\" type=\"setLVCoord\" time=\"";
  sprintf(conv,"%f",time);
  b += conv;

  b += "\" v_num=\"";
  sprintf(conv,"%d",cislo_vrcholu);
  b += conv;
  b += "\"";

  i = cislo_vrcholu;


    sprintf(conv," v%dx=\"%.4f\"",i,vertex.x);
    b += conv;
    sprintf(conv," v%dy=\"%.4f\"",i,vertex.y);
    b += conv;
    sprintf(conv," v%dz=\"%.4f\"",i,vertex.z);
    b += conv;

  b += "/>";

  //zapis bufferu do socketu
  c->Write((char*)b.c_str());


}

//**********************************************************************************

Cylinder::Cylinder(char* s,char* parent,float r1,float r2,float height)
{

  name = new char[strlen(s) + 1];
  strcpy(name,s);

  b = "<create type=\"cylinder\" name=\"";
  b += name;
  b += "\" parent=\"";
  if (parent == NULL)
    b += "NULL";
  else
    b += parent;
  b += "\" radius1=\"";
  sprintf(conv,"%f",r1);
  b += conv;
  b += "\" radius2=\"";
  sprintf(conv,"%f",r2);
  b += conv;
  b += "\" height=\"";
  sprintf(conv,"%f",height);
  b += conv;


  b += "\"/>";

  //zapis bufferu do socketu
  c->Write((char*)b.c_str());




}

//*************************************************************************

PolygonMatrix::PolygonMatrix(char *s,char* parent,int x,int y,int xsize, int ysize,float time)
// x udava pocet polygonu ve smeru osy x,
// y 		--||--
// xsize udava velikost matice v pixelech ve smeru osy x
// ysize	--||--
{

  nx = x;
  ny = y;

  name = new char[strlen(s) + 1];
  strcpy(name,s);



  b = "<create type=\"pMatrix\" name=\"";
  b += name;
  b += "\" parent=\"";
  if (parent == NULL)
    b += "NULL";
  else
    b += parent;
  b += "\" num_x=\"";
  sprintf(conv,"%d",x);
  b += conv;
  b += "\" num_y=\"";
  sprintf(conv,"%d",y);
  b += conv;
  b += "\" x_size=\"";
  sprintf(conv,"%d",xsize);
  b += conv;
  b += "\" y_size=\"";
  sprintf(conv,"%d",ysize);
  b += conv;
  b += "\" time=\"";
  sprintf(conv,"%f",time);
  b += conv;
  b += "\" />";

  c->Write((char*)b.c_str());
}




//*************************************************************************

void PolygonMatrix::setMVCoord(point **v,float time = 0.0)
{
  int i,j;

  //posila postupne po radcich
  for (i=0;i<=nx;i++)
  {
    b = "<command adress=\"";
    b += name;
    b += "\" type=\"setMVCoord\" time=\"";
    sprintf(conv,"%f",time);
    b += conv;
    b += "\" row=\"";
    sprintf(conv,"%d",i);
    b += conv;
    b += "\" ";

    //cout << i << ":" << b << endl;

    for (j=0;j<=ny;j++)
    {

      sprintf(conv,"x=\"%.4f\" ",v[i][j].x);
      b += conv;
      sprintf(conv,"y=\"%.4f\" ",v[i][j].y);
      b += conv;
      sprintf(conv,"z=\"%.4f\" ",v[i][j].z);
      b += conv;


    }
    b += " />";
    //cout << b << endl;

    c->Write((char*)b.c_str());

  }
}

//*************************************************************************
void PolygonMatrix::setMVColor(tColor **color,float time = 0.0)
{
  int i,j;

  //posila postupne po radcich
  for (i=0;i<nx;i++)
  {
    b = "<command adress=\"";
    b += name;
    b += "\" type=\"setMVColor\" time=\"";
    sprintf(conv,"%f",time);
    b += conv;
    b += "\" row=\"";
    sprintf(conv,"%d",i);
    b += conv;
    b += "\" ";

    //cout << i << ":" << b << endl;

    for (j=0;j<ny;j++)
    {
      sprintf(conv,"r=\"%.3f\" ",color[i][j].color[0]);
      b += conv;
      sprintf(conv,"g=\"%.3f\" ",color[i][j].color[1]);
      b += conv;
      sprintf(conv,"b=\"%.3f\" ",color[i][j].color[2]);
      b += conv;
      sprintf(conv,"a=\"%.3f\" ",color[i][j].color[3]);
      b += conv;

    }
    b += " />";
    //cout << b << endl;

    c->Write((char*)b.c_str());

  }
}

//*************************************************************************


