/*==========================================================================
   Vizualizacni server
   Copyright (c) 2003 Vladimir Florian
   All rights reserved.

  This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

   visualisation.h
   Zde je popis objektu, z kterych je mozne modelovat scenu na strane klienta
   ========================================================================*/


#ifndef VISUALISATION_H
#define VISUALISATION_H
#include <getopt.h>
#include "socket.h"


const char* const short_options = "ha:p:f:";

//specifikuje mozne parametry programu
const struct option long_options[] = {
  {"help",  0, NULL, 'h'},
  {"adress",1, NULL, 'a'},
  {"port",  1, NULL, 'p'},
  {"file",  1, NULL, 'f'},
  { NULL ,  0, NULL,  0 },
};


//*************************************************************************

class VClient
//trida slouzici pro inicializaci spojeni se serverem a poskytujici toto spojeni
//vsem prvkum rozhrani pomoci dedicnosti
{
public:

  static Socket *c;  //socket zajistujici spojeni

  static void print_usage(int exit_code); //vypise napovedu

  static int init(int argc,char **argv);  //inicializuje spojeni

  static void finish();  //ukonci spojeni


};

//*************************************************************************


//trida pro definici bodu v prostoru
struct point
{

  float x,y,z;
  int par;
  point(float xx = 0.0,float yy = 0.0, float zz = 0.0) { x=xx;y=yy;z=zz;}

};


//*************************************************************************

struct tColor //trida pro ulozeni barvy objektu
{
  float color[4];
  tColor(float r = 1.0, float g = 1.0, float b = 1.0, float a = 1.0)
  {
    color[0] = r;
    color[1] = g;
    color[2] = b;
    color[3] = a;
  }
};

//************************************************************************


//uzel stromu - provadi operace transformace
class DNode  : public VClient
{
char *name;

string b; //buffer pro vystup
char conv[30];

public:
  //zasle zpravu o vytvoreni noveho uzlu se jmenem name a rodicem parent
  DNode(char *s,char *parent);

  //rotace o uhel ang podle vektoru zadaneho souradnicemi xa,ya,za
  void rotate(float ang,float xa,float ya,float za,float time = 0.0);
  //transformace souradnic - posun na relativni souradnice
  void move(float x,float y,float z,float time = 0.0);
  //transformace souradnic - posun na absolutni souradnice
  void moveABS(float x,float y,float z,float time = 0.0);

  ~DNode() {delete[] name;}

};



//*************************************************************************

//slouzi pouze pro dedeni spolecnych vlastnosti vsech grafickych prvku
//jako je nastaveni barvy
class GElement : public VClient
{

public:
  char *name;
  string b;  //buffer pro vystup
  char conv[30];
  void setColor(float r,float g,float b,float time = 0.0);

};


//************************************************************************

class Sphere : public GElement
{

public:

  Sphere(char* s,char *parent,int radius = 10,int ph = 6,int vh = 6);

  void setRadius(int radius,float time = 0.0);


  ~Sphere() { delete[] name;}
};


//************************************************************************

class Cube : public GElement
{

public:

  Cube(char* name,char *parent,int size = 10);

  void setSize(int size,float time = 0.0);


  ~Cube() { delete[] name;}
};


//************************************************************************

class Polygon : public GElement
{

public:

  Polygon(char* name,char* parent,int pocet_vrcholu, point* vertex);

  ~Polygon() { delete[] name;}

  //nastavi souradnice urceneho vrcholu polygonu na pevnou hodnotu
  void setVCoord(int cislo_vrcholu,point vertex,float time = 0.0);
  //nastavi urcene vrcholy nekolika polygonu na stejne souradnice
  //je vhodne pro site vrcholu
  void setMVCoord(int pocet_vrcholu,char **name,int *v_num,point vertex,float time = 0.0);
};


//************************************************************************

class Line : public GElement
{


public:

  //pole vrcholu predavane konstruktoru musi obsahovat aspon dva body

  Line(char* name,char* parent,point* vertex);

  //nastavi souradnice urceneho vrcholu usecky na pevnou hodnotu
  void setVCoord(int cislo_vrcholu,point vertex,float time = 0.0);


  ~Line() { delete[] name;}
};

//*************************************************************************

class Cylinder : public GElement
{

public:

  Cylinder(char* name,char* parent,float r1,float r2,float height);

  ~Cylinder() { delete[] name;}
};


//*************************************************************************

class PolygonMatrix : public GElement
{
  int nx,ny;

public:

  PolygonMatrix(char *name,char* parent,int x,int y,int xsize, int ysize,float time = 0.0);

  void setMVCoord(point **v,float time = 0.0);

  void setMVColor(tColor **color,float time = 0.0);

  //void setColor(float r,float g,float b,float time = 0.0);

};

//*************************************************************************



#endif

