/*
 * Decompiled with CFR 0.152.
 */
package mefe;

import java.awt.Graphics;
import mefe.MFPaint;
import mefe.MemberFunction;

public class MFTrapezoid
extends MemberFunction {
    double min = 0.0;
    double vertexA = 0.0;
    double vertexB = 0.0;
    double max = 0.0;

    public MFTrapezoid() {
    }

    public MFTrapezoid(MFPaint p, String name, double min, double vertexA, double vertexB, double max) {
        this.setParent(p);
        this.setName(name);
        this.setMin(min);
        this.setVertexA(vertexA);
        this.setVertexB(vertexB);
        this.setMax(max);
        this.values = 4;
    }

    public void setMin(double x) {
        this.min = x;
        if (this.vertexA < this.min) {
            this.vertexA = this.min;
        }
        if (this.vertexB < this.min) {
            this.vertexB = this.min;
        }
        if (this.max < this.min) {
            this.max = this.min;
        }
    }

    public double getMin() {
        return this.min;
    }

    public void setMax(double x) {
        this.max = x;
        if (this.min > this.max) {
            this.max = this.min;
        }
        if (this.vertexA > this.max) {
            this.max = this.vertexA;
        }
        if (this.vertexB > this.max) {
            this.max = this.vertexB;
        }
    }

    public double getMax() {
        return this.max;
    }

    public void setVertexA(double x) {
        this.vertexA = x;
        if (this.min > this.vertexA) {
            this.min = this.vertexA;
        }
        if (this.vertexB < this.vertexA) {
            this.vertexB = this.vertexA;
        }
        if (this.max < this.vertexA) {
            this.max = this.vertexA;
        }
    }

    public double getVertexA() {
        return this.vertexA;
    }

    public void setVertexB(double x) {
        this.vertexB = x;
        if (this.min > this.vertexB) {
            this.min = this.vertexB;
        }
        if (this.vertexB < this.vertexA) {
            this.vertexA = this.vertexB;
        }
        if (this.max < this.vertexB) {
            this.max = this.vertexB;
        }
    }

    public double getVertexB() {
        return this.vertexB;
    }

    public void paint(Graphics g) {
        double K = (double)(this.parent.getMaxX() - this.parent.getMinX()) / (this.parent.getMax() - this.parent.getMin());
        g.drawLine(this.parent.getMinX() + (int)((this.min - this.parent.getMin()) * K), this.parent.getMaxY(), this.parent.getMinX() + (int)((this.vertexA - this.parent.getMin()) * K), this.parent.getMinY());
        g.drawLine(this.parent.getMinX() + (int)((this.vertexA - this.parent.getMin()) * K), this.parent.getMinY(), this.parent.getMinX() + (int)((this.vertexB - this.parent.getMin()) * K), this.parent.getMinY());
        g.drawLine(this.parent.getMinX() + (int)((this.vertexB - this.parent.getMin()) * K), this.parent.getMinY(), this.parent.getMinX() + (int)((this.max - this.parent.getMin()) * K), this.parent.getMaxY());
    }

    public double getValue(double x) {
        if (x <= this.min || x >= this.max) {
            return 0.0;
        }
        if (x >= this.vertexA && x <= this.vertexB) {
            return 1.0;
        }
        if (x < this.vertexA) {
            return (x - this.min) / (this.vertexA - this.min);
        }
        return (this.max - x) / (this.max - this.vertexB);
    }

    public double getValue(int x) {
        return this.getValue(this.parent.mousePosToXValue(x));
    }

    public boolean isEqual(MemberFunction mf) {
        if (mf.getType() == this.getType()) {
            MFTrapezoid m = (MFTrapezoid)mf;
            return this.name.equals(m.name) && this.min == m.min && this.max == m.max && this.vertexA == m.vertexA && this.vertexB == m.vertexB;
        }
        return false;
    }

    public int getType() {
        return 1;
    }

    public void modifyAll(MemberFunction mf) {
        if (mf.getType() != 1) {
            return;
        }
        this.setMin(((MFTrapezoid)mf).min);
        this.setVertexA(((MFTrapezoid)mf).vertexA);
        this.setVertexB(((MFTrapezoid)mf).vertexB);
        this.setMax(((MFTrapezoid)mf).max);
        this.setName(mf.getName());
        this.values = mf.values;
    }

    public double getMeanValue() {
        return (this.min + this.max) / (double)2 - (this.min + this.max - this.vertexA - this.vertexB) / ((double)2 * MemberFunction.SQRT2);
    }

    public void addDefValue(double value) {
        switch (this.values) {
            case 0: {
                this.setMin(value);
                ++this.values;
                break;
            }
            case 1: {
                this.setVertexA(value);
                ++this.values;
                break;
            }
            case 2: {
                this.setVertexB(value);
                ++this.values;
                break;
            }
            case 3: {
                this.setMax(value);
                ++this.values;
                break;
            }
        }
    }

    public boolean isComplete() {
        return this.values == 4;
    }

    public int getNumValues() {
        return 4;
    }

    public double getDefValue(int index) {
        switch (index) {
            case 0: {
                return this.min;
            }
            case 1: {
                return this.vertexA;
            }
            case 2: {
                return this.vertexB;
            }
            case 3: {
                return this.max;
            }
        }
        return 0.0;
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("FuzzyTrapez(\"").concat(String.valueOf(this.name))).concat(String.valueOf("\", "))).concat(String.valueOf(this.min))).concat(String.valueOf(", "))).concat(String.valueOf(this.vertexA))).concat(String.valueOf(", "))).concat(String.valueOf(this.vertexB))).concat(String.valueOf(", "))).concat(String.valueOf(this.max))).concat(String.valueOf(")"));
    }
}

