/*
 * Decompiled with CFR 0.152.
 */
package mefe.xml;

import java.io.IOException;
import mefe.FuzzyVendor;
import mefe.xml.ErrorReporter;
import mefe.xml.FuzzyHandler;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.SAXException;

public class FuzzyAnalyzator {
    private long analyzeTime = 0L;
    private FuzzyHandler handler;

    public void analyze(String systemId, boolean validation, boolean nameSpaces, boolean schemaSupport) throws IOException, SAXException {
        this.handler = new FuzzyHandler();
        SAXParser parser = new SAXParser();
        parser.setContentHandler(this.handler);
        parser.setErrorHandler(this.handler);
        parser.setFeature("http://xml.org/sax/features/validation", validation);
        parser.setFeature("http://xml.org/sax/features/namespaces", nameSpaces);
        parser.setFeature("http://apache.org/xml/features/validation/schema", schemaSupport);
        long before = System.currentTimeMillis();
        parser.parse(systemId);
        long after = System.currentTimeMillis();
        this.analyzeTime = after - before;
        if (this.handler.getNumErrors() + this.handler.getNumFatalErrors() > 0) {
            throw new SAXException(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("").concat(String.valueOf(this.handler.getNumErrors()))).concat(String.valueOf(" errors and "))).concat(String.valueOf(this.handler.getNumFatalErrors()))).concat(String.valueOf(" fatal errors in document \""))).concat(String.valueOf(systemId))).concat(String.valueOf("\".")));
        }
    }

    public FuzzyVendor getFuzzyVendor() {
        return this.handler;
    }

    public boolean isErrorOrWarning() {
        return this.handler.isErrorOrWarning();
    }

    public ErrorReporter getErrorReporter() {
        return this.handler;
    }

    public long getAnalyzeTime() {
        return this.analyzeTime;
    }
}

