/*
 * Decompiled with CFR 0.152.
 */
package mefe.xml;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import mefe.FuzzyClass;
import mefe.FuzzyModel;
import mefe.FuzzyType;
import mefe.MemberFunction;

public class XMLWriter {
    public static final String XMLHEAD = "<?xml version=\"1.0\" standalone=\"no\"?>\n<!DOCTYPE fuzzymodel [\n  <!ELEMENT fuzzymodel (fuzzyclass|fuzzytype)>\n\n  <!ELEMENT fuzzyclass (fuzzytype, fuzzytype, fuzzytype, behavior)>\n  <!ATTLIST fuzzyclass\n    classname CDATA #REQUIRED\n  >\n\n  <!ELEMENT fuzzytype (fuzzymf+)>\n  <!ATTLIST fuzzytype\n    typename CDATA #REQUIRED\n    minrange CDATA #REQUIRED\n    maxrange CDATA #REQUIRED\n  >\n\n  <!ELEMENT fuzzymf (value+)>\n  <!ATTLIST fuzzymf\n    mftype    CDATA #REQUIRED\n    wordvalue CDATA #REQUIRED\n  >\n  <!ELEMENT value EMPTY>\n  <!ATTLIST value\n    value     CDATA #REQUIRED\n  >\n\n  <!ELEMENT behavior (row+)>\n\n  <!ELEMENT row (outvalue+)>\n  <!ELEMENT outvalue EMPTY>\n  <!ATTLIST outvalue\n    value     CDATA #REQUIRED\n  >\n]>\n<fuzzymodel>\n";
    public static final String XMLFOOT = "</fuzzymodel>\n";

    public static String MFTypeToString(int mftype) {
        switch (mftype) {
            case 2: {
                return "FuzzySingleton";
            }
            case 0: {
                return "FuzzyTriangle";
            }
            case 1: {
                return "FuzzyTrapez";
            }
            case 3: {
                return "FuzzyGauss";
            }
        }
        return "Unknown";
    }

    public static String MemberFunctionToString(MemberFunction mf, String indent) {
        String s = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(indent).concat(String.valueOf("<fuzzymf mftype=\""))).concat(String.valueOf(XMLWriter.MFTypeToString(mf.getType())))).concat(String.valueOf("\" "))).concat(String.valueOf("wordvalue=\""))).concat(String.valueOf(mf.getName()))).concat(String.valueOf("\">\n"));
        for (int i = 0; i < mf.getNumValues(); ++i) {
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(indent).concat(String.valueOf("  <value value=\""))).concat(String.valueOf(mf.getDefValue(i)))).concat(String.valueOf("\"/>\n"))));
        }
        return String.valueOf(String.valueOf(s).concat(String.valueOf(indent))).concat(String.valueOf("</fuzzymf>\n"));
    }

    public static String TypeToString(FuzzyType ft, String indent) {
        String s = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(indent).concat(String.valueOf("<fuzzytype typename=\""))).concat(String.valueOf(ft.getName()))).concat(String.valueOf("\" "))).concat(String.valueOf("minrange=\""))).concat(String.valueOf(ft.getMinRange()))).concat(String.valueOf("\" "))).concat(String.valueOf("maxrange=\""))).concat(String.valueOf(ft.getMaxRange()))).concat(String.valueOf("\">\n"));
        Enumeration e = ft.getFunctions().elements();
        while (e.hasMoreElements()) {
            s = String.valueOf(s).concat(String.valueOf(XMLWriter.MemberFunctionToString((MemberFunction)e.nextElement(), String.valueOf(indent).concat(String.valueOf("  ")))));
        }
        return String.valueOf(String.valueOf(s).concat(String.valueOf(indent))).concat(String.valueOf("</fuzzytype>\n"));
    }

    public static String ClassToString(FuzzyClass fc, String indent) {
        String s = String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(indent).concat(String.valueOf("<fuzzyclass classname=\""))).concat(String.valueOf(fc.getName()))).concat(String.valueOf("\">\n"))).concat(String.valueOf(XMLWriter.TypeToString(fc.getIn1(), String.valueOf(indent).concat(String.valueOf("  ")))))).concat(String.valueOf(XMLWriter.TypeToString(fc.getIn2(), String.valueOf(indent).concat(String.valueOf("  ")))))).concat(String.valueOf(XMLWriter.TypeToString(fc.getOut(), String.valueOf(indent).concat(String.valueOf("  ")))))).concat(String.valueOf(indent))).concat(String.valueOf("  <behavior>\n"));
        int[][] grid = fc.getGrid();
        for (int y = 0; y < grid[0].length; ++y) {
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(indent).concat(String.valueOf("    <row>\n"))).concat(String.valueOf(indent))).concat(String.valueOf("      "))));
            Vector v = fc.getOut().getFunctions();
            for (int x = 0; x < grid.length; ++x) {
                s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf("<outvalue value=\"").concat(String.valueOf(((MemberFunction)v.elementAt(grid[x][y])).getName()))).concat(String.valueOf("\"/> "))));
            }
            s = String.valueOf(s).concat(String.valueOf(String.valueOf(String.valueOf("\n").concat(String.valueOf(indent))).concat(String.valueOf("    </row>\n"))));
        }
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(s).concat(String.valueOf(indent))).concat(String.valueOf("  </behavior>\n"))).concat(String.valueOf(indent))).concat(String.valueOf("</fuzzyclass>\n"));
    }

    public static void writeToFile(FileOutputStream f, FuzzyModel fm, String indent) throws IOException {
        f.write(XMLHEAD.getBytes());
        if (fm instanceof FuzzyType) {
            f.write(XMLWriter.TypeToString((FuzzyType)fm, indent).getBytes());
        } else if (fm instanceof FuzzyClass) {
            f.write(XMLWriter.ClassToString((FuzzyClass)fm, indent).getBytes());
        }
        f.write(XMLFOOT.getBytes());
    }
}

