/*
 * Decompiled with CFR 0.152.
 */
package mefe;

import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.util.Enumeration;
import java.util.Vector;
import mefe.FuzzyType;
import mefe.MFPaint;
import mefe.MemberFunction;

public class Fuzzy1DEditor
extends Canvas
implements MFPaint {
    double min;
    double max;
    Dimension preferredSize;
    Vector functions = new Vector(5);
    public static int upMargin = 10;
    public static int downMargin = 20;
    public static int leftMargin = 10;
    public static int rightMargin = 10;

    public Fuzzy1DEditor() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void drawBackground() {
        Dimension d = this.getSize();
        Graphics g = this.getGraphics();
        FontMetrics fm = this.getFontMetrics(this.getFont());
        g.setPaintMode();
        g.drawLine(leftMargin, upMargin - 2, leftMargin, d.height - downMargin + 2);
        g.drawLine(leftMargin - 2, d.height - downMargin, d.width - rightMargin + 2, d.height - downMargin);
        g.drawLine(leftMargin - 2, upMargin, leftMargin + 2, upMargin);
        g.drawLine(d.width - rightMargin, d.height - downMargin - 2, d.width - rightMargin, d.height - downMargin + 2);
        g.drawString(String.valueOf("").concat(String.valueOf(this.min)), 5, d.height - 5);
        g.drawString(String.valueOf("").concat(String.valueOf(this.max)), d.width - 5 - fm.stringWidth(String.valueOf("").concat(String.valueOf(this.max))), d.height - 5);
    }

    private void jbInit() throws Exception {
        this.setBackground(Color.cyan);
        this.validate();
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public void setMin(double f) {
        this.min = f;
        this.repaint();
    }

    public void setMax(double f) {
        this.max = f;
        this.repaint();
    }

    public Dimension getPreferredSize() {
        this.preferredSize = this.getSize();
        return this.preferredSize;
    }

    public void setPreferredSize(Dimension d) {
        this.preferredSize = d;
        this.setSize(this.preferredSize);
        this.repaint();
    }

    public void paint(Graphics g) {
        this.drawBackground();
        Enumeration e = this.functions.elements();
        while (e.hasMoreElements()) {
            MemberFunction mf = (MemberFunction)e.nextElement();
            mf.paint(g);
        }
    }

    public int getMinX() {
        return leftMargin;
    }

    public int getMaxX() {
        return this.getSize().width - rightMargin;
    }

    public int getMinY() {
        return upMargin;
    }

    public int getMaxY() {
        return this.getSize().height - downMargin;
    }

    public double mousePosToXValue(int x) {
        return (double)(x - this.getMinX()) * (this.max - this.min) / (double)(this.getMaxX() - this.getMinX()) + this.min;
    }

    public void addFunction(MemberFunction mf) {
        int index = 0;
        Enumeration e = this.functions.elements();
        while (e.hasMoreElements() && !(((MemberFunction)e.nextElement()).getMeanValue() > mf.getMeanValue())) {
            ++index;
        }
        this.functions.insertElementAt(mf, index);
        this.repaint();
    }

    public void removeFunction(MemberFunction mf) {
        this.functions.removeElement(mf);
        this.repaint();
    }

    public void modifyFunction(MemberFunction oldf, MemberFunction newf) {
        if (this.functions.removeElement(oldf)) {
            this.addFunction(newf);
        }
        this.repaint();
    }

    public MemberFunction getNearestFunction(int x) {
        MemberFunction maxmf;
        Enumeration e = this.functions.elements();
        if (!e.hasMoreElements()) {
            return null;
        }
        MemberFunction mf = maxmf = (MemberFunction)e.nextElement();
        while (e.hasMoreElements()) {
            mf = (MemberFunction)e.nextElement();
            if (!(mf.getValue(x) > maxmf.getValue(x))) continue;
            maxmf = mf;
        }
        if (maxmf.getValue(x) != (double)0.0f) {
            return maxmf;
        }
        double mousex = this.mousePosToXValue(x);
        e = this.functions.elements();
        maxmf = null;
        double mindelta = Double.POSITIVE_INFINITY;
        double delta = 0.0;
        while (e.hasMoreElements()) {
            mf = (MemberFunction)e.nextElement();
            delta = Math.abs(mf.getMeanValue() - mousex);
            if (!(delta < mindelta)) continue;
            mindelta = delta;
            maxmf = mf;
        }
        return maxmf;
    }

    public boolean contains(MemberFunction mf) {
        Enumeration e = this.functions.elements();
        while (e.hasMoreElements()) {
            if (!mf.isEqual((MemberFunction)e.nextElement())) continue;
            return true;
        }
        return false;
    }

    public void removeAll() {
        this.functions.removeAllElements();
    }

    public Enumeration getFunctions() {
        return this.functions.elements();
    }

    public int getNumFunctionts() {
        return this.functions.size();
    }

    public void importFromFuzzyType(FuzzyType ft) {
        this.min = ft.getMinRange();
        this.max = ft.getMaxRange();
        this.functions = ft.getFunctions();
        Enumeration e = this.functions.elements();
        while (e.hasMoreElements()) {
            ((MemberFunction)e.nextElement()).setParent(this);
        }
    }
}

