/*
 * Decompiled with CFR 0.152.
 */
package mefe;

import java.awt.Graphics;
import mefe.MFPaint;
import mefe.MemberFunction;

public class MFGauss
extends MemberFunction {
    double mi = 0.0;
    double sigma2 = 0.0;
    double radius = 0.0;

    public MFGauss() {
    }

    public MFGauss(MFPaint p, String name, double vertex, double radius) {
        this.parent = p;
        this.setVertex(vertex);
        this.setRadius(radius);
        this.setName(name);
        this.values = 2;
    }

    public double getRadius() {
        return this.radius;
    }

    public void setRadius(double radius) {
        this.radius = radius;
        this.sigma2 = radius / (double)3 * (radius / (double)3);
    }

    public void setVertex(double vertex) {
        this.mi = vertex;
    }

    public double getVertex() {
        return this.mi;
    }

    public void paint(Graphics g) {
        int minX = this.parent.getMinX();
        int minY = this.parent.getMinY();
        int maxX = this.parent.getMaxX();
        int maxY = this.parent.getMaxY();
        double K = (double)(maxX - minX) / (this.parent.getMax() - this.parent.getMin());
        double L = maxY - minY;
        int x1 = minX + (int)((this.mi - this.parent.getMin()) * K);
        int y1 = minY;
        int xmi = x1;
        int x2 = 0;
        int y2 = 0;
        for (double i = this.mi + this.radius / (double)15; i < this.mi + (double)3 * this.radius; i += this.radius / (double)15) {
            x2 = minX + (int)((i - this.parent.getMin()) * K);
            y2 = maxY - (int)(this.getValue(i) * L);
            g.drawLine(x1, y1, x2, y2);
            g.drawLine(xmi - (x1 - xmi), y1, xmi - (x2 - xmi), y2);
            x1 = x2;
            y1 = y2;
            if (maxX <= x1 && minX >= xmi - (x1 - xmi)) break;
        }
        if (maxX > x1) {
            g.drawLine(x1, y1, maxX, y1);
        }
        if (minX < xmi - (x1 - xmi)) {
            g.drawLine(minX, y1, xmi - (x1 - xmi), y1);
        }
    }

    public double getValue(double x) {
        if (this.sigma2 == 0.0) {
            if (x == this.mi) {
                return this.mi;
            }
            if (x != this.mi) {
                return 0.0;
            }
        }
        return Math.exp(-((x - this.mi) * (x - this.mi)) / ((double)2 * this.sigma2));
    }

    public double getValue(int x) {
        return this.getValue(this.parent.mousePosToXValue(x));
    }

    public boolean isEqual(MemberFunction mf) {
        if (mf.getType() == this.getType()) {
            MFGauss m = (MFGauss)mf;
            return this.name.equals(m.name) && this.radius == m.radius && this.mi == m.mi;
        }
        return false;
    }

    public int getType() {
        return 3;
    }

    public void modifyAll(MemberFunction mf) {
        if (mf.getType() != 3) {
            return;
        }
        this.setRadius(((MFGauss)mf).getRadius());
        this.setVertex(((MFGauss)mf).mi);
        this.setName(mf.getName());
        this.values = mf.values;
    }

    public double getMeanValue() {
        return this.mi;
    }

    public void addDefValue(double value) {
        switch (this.values) {
            case 0: {
                this.setVertex(value);
                ++this.values;
                break;
            }
            case 1: {
                this.setRadius(value);
                ++this.values;
                break;
            }
        }
    }

    public boolean isComplete() {
        return this.values == 2;
    }

    public int getNumValues() {
        return 2;
    }

    public double getDefValue(int index) {
        switch (index) {
            case 0: {
                return this.mi;
            }
            case 1: {
                return this.getRadius();
            }
        }
        return 0.0;
    }
}

