////////////////////////////////////////////////////////////////////////////
// Model micek                   SIMLIB/C++
//
// Skkajc mek (kombinovan model, varianta 1)
//

#include "simlib.h"

const double g = 9.81;          // gravitan zrychlen

class Micek : ConditionDown {   // popis modelu mku
  Integrator v,y;               // stav
  unsigned count;               // ta dopad
  void Action()  {              // je dopad
      Print("# Odraz %u:\n", ++count);
      Out();                    // tiskneme stav pi dopadu
      v = -0.8 * v.Value();     // ztrta energie...
      y = 0;            // je nutn pro detekci dalho dopadu !!!
      if(count>=20)             // povolme max. 20 odraz
        Stop();                 // konec simulace
  }
public:
  Micek(double initialposition) :
    ConditionDown(y),           // podmnka dopadu: (y>=0) z TRUE na FALSE
    v(-g),                      // y' = INTG( - m * g )
    y(v, initialposition),      // y  = INTG( y' )
    count(0) {}                 // poet dopad
  void Out() {
    Print("%-9.3f  % -9.3g  % -9.3g\n",
          T.Value(), y.Value(), v.Value());
  }
};

Micek m1(1.0);                  // model systmu

void Sample() { m1.Out(); }     // vstup stavu mku
Sampler S(Sample,0.01);

int main() {                    // popis experimentu
  SetOutput("micek.dat");
  Print("# MICEK --- model skkajcho mku\n");
  Print("# Time y v \n");
  Init(0);                      // inicializace parametr experimentu
  SetStep(1e-10,0.5);           // rozsah kroku integrace
  SetAccuracy(1e-5,0.001);      // max. povolen chyba integrace
  Run();                        // simulace
  SIMLIB_statistics.Output();   // print run statistics
}

//
