////////////////////////////////////////////////////////////////////////////
// Model MODEL4                   SIMLIB/C++
//
// Ukzkov model obslunho stediska (2 zazen 1 fronta)
//

#include "simlib.h"
#include <stdio.h>

// deklarace globlnch objekt
Facility  Box[2];                 // bohuel nelze inicializovat
Queue InQueue("ekajc zkaznci");
Histogram Tabulka("Tabulka",0,5,20);

class Zakaznik : public Process { // tda zkaznk
  double Prichod;                 // atribut kadho zkaznka
  void Behavior() {               // --- popis chovn zkaznka ---
    Prichod = Time;               // as pchodu zkaznka
    if (!Box[0].Busy())      Seize(Box[0]); // obsazen zazen1
    else if (!Box[1].Busy()) Seize(Box[1]); // obsazen zazen2
    else { 
        Into(InQueue); Passivate(); // ekn ve front
	// zazen1 nebo zazen2 pi Release automaticky obsad
        // pozor - zmna smantiky ve verzi SIMLIB 2.17
    }
    Wait(10);                     // obsluha
    // pozor!! nevme, kter zazen jsme skuten obsadili
    if (Box[0].in==this) Release(Box[0]); // uvolnn
    else                 Release(Box[1]);
    Tabulka(Time-Prichod);        // doba obsluhy a ekn
  }
  public: Zakaznik() { Activate(); } // konstruktor aktivuje
};

class Generator : public Event {  // genertor zkaznk
  void Behavior() {               // --- popis chovn genertoru ---
    new Zakaznik;                 // nov zkaznk
    Activate(Time+Exponential(1e3/150));  // interval mezi pchody
  }
  public: Generator() { Activate(); } // konstruktor aktivuje
};

int main() {
  SetOutput("model4.out");
  Print(" MODEL4 - test SIMLIB\n");
  Init(0,1000);              // inicializace experimentu, as bude 0..1000
  Box[0].SetQueue(InQueue);
  Box[0].SetName("Box[0]");
  Box[1].SetQueue(InQueue);
  Box[1].SetName("Box[1]");
  new Generator;             // genertor zkaznk
  Run();                     // simulace
  Box[0].Output();           // tisk vsledk
  Box[1].Output();
  InQueue.Output();
  Tabulka.Output();
  SIMLIB_statistics.Output();     // print run statistics
}

//
