BOOST_AUTO_TEST_CASE(xlogin99_pokusny_dummy_true)
{
    BOOST_CHECK(true);
}

// for xlogin99_process test case
class xlogin99_Process : public Process {
public:
    int &mark;
    int delay;
    int mark_should_be;
    int increment;
    
    xlogin99_Process(int &m, int d, int expected, int incr) :
        mark(m)
    {
        delay = d;
        mark_should_be = expected;
        increment = incr;
    }
    
    void Behavior()
    {
        Wait(delay);
        if (mark == mark_should_be)
            mark += increment;
    }
};

/**
 * @desc Trivial check that calendar works as expected, i.e.,
 * P1->Waits(2); P2->Waits(1);
 *       |           \-------- if (mark==0) increment by 12
 *       \-------------------- if (mark==12) increment by 30
 */
BOOST_AUTO_TEST_CASE(xlogin99_process)
{
    // setup
    Init(0,5);
    SetStep(0.1,1.0);
    SetAccuracy(1e-5,0.01);

    int mark = 0;

    xlogin99_Process *P1 = new xlogin99_Process(mark, 2, 12, 30);
    P1->Activate();
    xlogin99_Process P2(mark, 1, 0, 12);
    P2.Activate();

    // exercise
    Run(); 

    // check
    BOOST_CHECK_EQUAL(mark, 42);

    // teardown
    // ?
}
