////////////////////////////////////////////////////////////////////////////
// Model: kyvadlo3.cc -- vysok pesnost vpotu
// text encoding: iso-8859-2
// 
// Netlumen kyvadlo -- ty
//
// (c) PerPet 1995, 2001
// TODO: ovit sprvnost

#include "simlib.h"
#include <iostream>
#include <fstream>
using namespace std;

const double g = 9.81;   // gravitan zrychlen
double Length = 1;            // dlka

// popis systmu:   x'' + omega^2 * sin(x) = 0,  omega^2 = g/L
struct Kyvadlo {
  Parameter L;
  Integrator x1;          // hlov rychlost
  Integrator x;           // hel vychlen
  Kyvadlo(double len):
    L(len),
    x1( - g/L * Sin(x) ),
    x( x1 ) { }
  void PrintParameters() { 
     cout << "# L = " << L.Value();
     cout << ", x0 = " << x.Value() << ", y0 = " << x1.Value() << "\n"; 
  }
};

Kyvadlo k(Length);

// sledovani stavu modelu ...
void Sample() { 
  cout << Time << ' ' << k.x.Value() << ' ' << k.x1.Value() << "\n"; 
}
Sampler S(Sample, 0.1);

// popis experimentu ...
int main() {
  cout << "# Model: kyvadlo3 \n";
  ifstream input("kyvadlo3.in"); // soubor s popisem parametr experiment
  if(!input) { 
    cerr << "soubor potench hodnot 'kyvadlo3.in' neexistuje"; 
    return 0; 
  }
  input >> Length; 
  k.L = Length;
  cerr << "Model kyvadla \nL = " << Length << "\n";
  while(1) {
    double x, y, t;
    input >> x >> y >> t;
    if(!input) break;
    cerr << "x0 = " << x << ",  \t y0 = " << y << "\n";
    k.x.Init(x);                    // poten hodnoty
    k.x1.Init(y);                    
    cout << "\n";                   // oddl vstupy
    k.PrintParameters();
    Init(0,t);                      // inicializace experimentu
    SetAccuracy(1e-14);             // nutn pro vysokou pesnost
    Run();                          // simulace
  }
  cout << "# konec \n";
}

