////////////////////////////////////////////////////////////////////////////
// Model kostky               SIMLIB/C++
//
// Example of queueing system
//
// Pklad simulanho programu - prodejna s Rubikovmi kostkami (verze 1)
//
// Do hrakstv pivezli Rubikovy kostky: rno v 8 hodin 500 kus
// a odpoledne  v 15  hodin opt  500 kus.  V hrakstv se otevr
// v 8 hodin rno a zavr se  v 18 hodin veer. Zkaznci pichzeli
// od  8  hodin  prmrn  po  3/4 minuty (s  exponencilnm
// rozloenm) a  kad zkaznk  koupil jen jednu kostku. Kdy
// u byly  vechny kostky  vyprodny, zkaznci  se  nevzdali, stli
// zpsobn ve front  a ekali, a  pivezou dalch  500 kus odpo-
// ledne v 15 hodin. Mezitm  ovem pichzeli nov zkaznci. Urete
// max. dlku fronty  a prmrnou  dobu ekn, spotejte, kolik z-
// kaznk  odelo  s nepozenou, protoe vedouc prodejnu  striktn
// zavela  v 18 hodin  a nebrala  ohled  na lidi, kte  u stli ve
// front. Po 18.hodin u dal zkaznci nepichzeli. Doba obsluhy
// je 1 minuta.
//
// Zdroj: domc koly student

#include "simlib.h"

// time of simulation:  T_POC - start, T_KON - stop
const double T_POC = 8.0;   // hodin
const double T_KON = 18.0;  // hodin

// definice konstant
const double T_OBSLUHY  = 1.0/60;   // doba obsluhy zkaznka - 1 minuta
const double T_DODAVKY1 = T_POC;    // as dodvky kostek - rno
const double T_DODAVKY2 = 15.0;     // as dodvky kostek - odpoledne
const double T_PRICH    = 0.75/60;  // prmrn interval pchodu zkaznk 3/4 min

// deklarace globalnich objektu
Facility  Prodejna;           // prodejna kostek
Histogram Tabulka ("ekac doby zkaznk",0,0.15,20);
                              // histogram pro zznam ekacch dob zkaznk
unsigned Kostek = 0;          // poet kostek v prodejn
unsigned PocZakazniku = 0;    // celkov poet neobslouench zkaznk


class Zakaznik : public Process {  // tda zkaznk
  double Prichod;               // as pchodu kadho zkaznka
  void Behavior() {             // popis chovn zkaznka
    Prichod = Time;
    PocZakazniku++;
    Seize(Prodejna);
    WaitUntil(Kostek > 0);      // ekej, jestlie kostky nejsou
    Kostek--;
    Wait(T_OBSLUHY);
    Release(Prodejna);
    PocZakazniku--;
    Tabulka(Time - Prichod);    // zznam doby ekn do tabulky
  }
};

class Generator : public Event {        // genertor zkaznk
  void Behavior() {                     // popis chovn genertoru
    (new Zakaznik)->Activate();         // nov zkaznk
    Activate(Time+Exponential(T_PRICH));
  }
};

class Dodavka : public Event {          // supply
  void Behavior() {
     Kostek = Kostek + 500;
// corrected:  Terminate();
  }
};

int main() {
    SetOutput("kostky.out");    // output redirection
    Prodejna.SetName("Prodejna");
    Init(T_POC, T_KON);         // initialize, non-zero initial time
    Tabulka.Clear();            // we start at non-zero time
    Prodejna.Clear();
    (new Dodavka)->Activate(T_DODAVKY1);        // morning supply
    (new Dodavka)->Activate(T_DODAVKY2);        // afternoon
    (new Generator)->Activate();        // incoming customers generator
    Print(" KOSTKY --- simulace obchodu\n");
    Run();                      // simulation
    Print("\n S nepozenou odelo %u zkaznk \n\n", PocZakazniku);
    Prodejna.Output();          // print results
    Tabulka.Output();
    SIMLIB_statistics.Output(); // print run statistics
}

//
