////////////////////////////////////////////////////////////////////////////
// Model kostky2              SIMLIB/C++
//
// Pklad simulanho programu - prodejna s Rubikovmi kostkami (verze 2)
//
// Do hrakstv pivezli Rubikovy kostky: rno v 8 hodin 500 kus
// a odpoledne  v 15  hodin opt  500 kus.  V hrakstv se otevr
// v 8 hodin rno a zavr se  v 18 hodin veer. Zkaznci pichzeli
// od  8  hodin  prmrn  po  3/4 minuty (s  exponencilnm
// rozloenm) a  kad zkaznk  koupil jen jednu kostku. Kdy
// u byly  vechny kostky  vyprodny, zkaznci  se  nevzdali, stli
// zpsobn ve front  a ekali, a  pivezou dalch  500 kus odpo-
// ledne v 15 hodin. Mezitm  ovem pichzeli nov zkaznci. Urete
// max. dlku fronty  a prmrnou  dobu ekn, spotejte, kolik z-
// kaznk  odelo  s nepozenou, protoe vedouc prodejnu  striktn
// zavela  v 18 hodin  a nebrala  ohled  na lidi, kte  u stli ve
// front. Po 18.hodin u dal zkaznci nepichzeli. Doba obsluhy
// je 1 minuta.
//

//#define SIMLIB_DEBUG 1
#include "simlib.h"

// doba simulace :  T_POC - poten, T_KON - konen
const double T_POC =  8.0;  // hodin
const double T_KON = 18.0;  // hodin

// konstanty:
const double T_OBSLUHY  = 1.0/60;    // doba obsluhy zkaznka - 1 minuta
const double T_DODAVKY1 = T_POC;     // as dodvky kostek - rno
const double T_DODAVKY2 = 15.0;      // as dodvky kostek - odpoledne
const double T_PRICH    = 0.75/60;   // prmrn interval pchodu zkaznk 3/4 min

// histogram pro zznam ekacch dob zkaznk
Histogram Tabulka ("ekac doby zkaznk",0,0.15,20);

unsigned PocZakazniku = 0;   // celkov poet neobslouench zkaznk

Queue F("Fronta zkaznk");

class Zakaznik : public Process {  // tda zkaznk
  double Prichod;                  // as pchodu zkaznka
  void Behavior() {                // popis chovn
    Prichod = Time;
    PocZakazniku++;
    Into(F);                       // nkup kdy jsou, jinak ekn
    Passivate();
    // obsluha v obchode
    PocZakazniku--;
    Tabulka(Time - Prichod);       // zznam doby ekn do tabulky
  }
};

class Obchod : public Process {
  int Sklad;
 public:
  Obchod() { Sklad = 0; Activate(); }
  void Behavior() {
    for(;;)
    {
      if(Sklad==0) Passivate();
      WaitUntil(!F.Empty());
      Zakaznik *z = (Zakaznik *)F.GetFirst();
      Wait(T_OBSLUHY);
      z->Activate();
      Sklad--;
    }
  }
  void Dodavka(int ks) {
    Sklad += ks;
    if(Sklad>0) Activate();
  }
  ~Obchod() {    
    Print("Ve skladu zbylo %d kostek\n", Sklad);
  }
};


class Generator : public Event {        // genertor zkaznk
  void Behavior() {                     // popis chovn genertoru
    (new Zakaznik)->Activate();         // nov zkaznk
    Activate(Time+Exponential(T_PRICH));
  }
};

class Dodavka : public Event {          // dodvka kostek
  Obchod *Kam;
  void Behavior() {
     Kam->Dodavka(500);
     //Terminate(); no more needed - was SIMLIB BUG
  }
 public:
  Dodavka(Obchod *kam, double kdy) {
    Kam=kam;
    Activate(kdy);
  }
};

////////////////////////////////////////////////////////////////////////////
// experiment
//
int main() {
  SetOutput("kostky2.out");          // nastaven vstupnho souboru
  Init(T_POC,T_KON);                 // inicializace experimentu
  Tabulka.Clear(); // we start at non-zero time
  F.Clear();
  Obchod *o = new Obchod;
  new Dodavka(o,T_DODAVKY1);         // inicializace dodvky zbo rno
  new Dodavka(o,T_DODAVKY2);         // inicializace dodvky zbo odpoledne
  (new Generator)->Activate();       // inicializace genertoru zkaznk
  Print(" KOSTKY2 --- simulace obchodu\n");
  Run();                             // simulace
  Print("\n S nepozenou odelo %u zkaznk \n\n", PocZakazniku);
  Tabulka.Output();
  F.Output();
  SIMLIB_statistics.Output();     // print run statistics
}

//
