////////////////////////////////////////////////////////////////////////////
// Model MODEL2                   SIMLIB/C++
//
// Ukzkov model jednoduchho obslunho stediska
//

#include "simlib.h"

// deklarace globlnch objekt
Facility  Box("Linka");
Histogram Tabulka("Tabulka",0,25,20);

class Zakaznik : public Process { // tda zkaznk
  double Prichod;                 // atribut kadho zkaznka
  void Behavior() {               // --- popis chovn zkaznka ---
    Prichod = Time;               // as pchodu zkaznka
    Seize(Box);                   // obsazen zazen Box
    Wait(10);                     // obsluha
    Release(Box);                 // uvolnn
    Tabulka(Time-Prichod);        // doba obsluhy a ekn
  }
};

class Generator : public Event {  // genertor zkaznk
  void Behavior() {               // --- popis chovn genertoru ---
    (new Zakaznik)->Activate();   // nov zkaznk, aktivace v ase Time
    Activate(Time+Exponential(1e3/150));  // interval mezi pchody
  }
};

int main() {                 // popis experimentu s modelem
  //DebugON();
  SetOutput("model2.out");
  Print(" MODEL2 - pklad SIMLIB/C++\n");
  Init(0,1000);              // inicializace experimentu, as bude 0..1000
  (new Generator)->Activate(); // genertor zkaznk, jeho aktivace
  Run();                     // simulace
  Box.Output();              // tisk vsledk
  Tabulka.Output();
  SIMLIB_statistics.Output();     // print run statistics
}

//
