////////////////////////////////////////////////////////////////////////////
// Model MODEL3                   SIMLIB/C++
//
// Ukzkov model obslunho stediska s 5 msty
//

#include "simlib.h"

// deklarace globlnch objekt
Store Box("Linka",5);
Histogram Tabulka("Tabulka",0,5,20);

class Zakaznik : public Process { // tda zkaznk
  double Prichod;                 // atribut kadho zkaznka
  int kolik;
  void Behavior() {               // --- popis chovn zkaznka ---
    Prichod = Time;               // as pchodu zkaznka
    kolik = 1 + int(3*Random());  // cel slo 1 .. 3
    Enter(Box,kolik);             // obsazen zazen
    Wait(10);                     // obsluha
    Leave(Box,kolik);             // uvolnn
    Tabulka(Time-Prichod);        // doba obsluhy a ekn
  }
  public: Zakaznik() { Activate(); } // konstruktor aktivuje
}; // Zakaznik

class Generator : public Event {  // genertor zkaznk
  void Behavior() {               // --- popis chovn genertoru ---
    new Zakaznik;                 // nov zkaznk
    Activate(Time+Exponential(1e3/150));  // interval mezi pchody
  }
  public: Generator() { Activate(); } // konstruktor aktivuje
};

int main() {
  SetOutput("model3.out");
  Print(" MODEL3 - test SIMLIB\n");
  Init(0,1000);              // inicializace experimentu, as bude 0..1000
  new Generator;             // genertor zkaznk
  Run();                     // simulace
  Box.Output();              // tisk vsledk
  Tabulka.Output();
  SIMLIB_statistics.Output();     // print run statistics
}

//
