////////////////////////////////////////////////////////////////////////////
// Model MODEL5                   SIMLIB/C++
//
// Ukzkov model obslunho stediska (2 zazen 1 fronta), jin strategie
//

#include "simlib.h"

// deklarace globlnch objekt
Facility  Box[2];                 // bohuel nelze inicializovat
Queue InQueue("Vstupn");
Histogram Tabulka("Tabulka",0,5,20);

class Zakaznik : public Process { // tda zkaznk
  double Prichod;                 // atribut kadho zkaznka
  int BoxNum;
  void Behavior() {               // --- popis chovn zkaznka ---
    Prichod = Time;               // as pchodu zkaznka
    BoxNum = (Random()<0.5) ? 0 : 1;
    if (Box[BoxNum].Busy()) 
      {Into(InQueue); Passivate(); } // ##### ????? !!!!!!
    Seize(Box[BoxNum]);           // obsazen zazen
    Wait(10);                     // obsluha
    Release(Box[BoxNum]);         // uvolnn
    for( Queue::iterator p = InQueue.begin();
         p != InQueue.end();
         ++p ) {
      Zakaznik *z = (Zakaznik*)(*p);
      if( z->BoxNum == BoxNum ) {
        z->Out();
        z->Activate();
        break;
      }
    } // for 
    Tabulka(Time-Prichod);        // doba obsluhy a ekn
  }
  public: Zakaznik() { Activate(); } // konstruktor aktivuje
}; // Zakaznik

class Generator : public Event {  // genertor zkaznk
  void Behavior() {               // --- popis chovn genertoru ---
    new Zakaznik;                 // nov zkaznk
    Activate(Time+Exponential(1e3/150));  // interval mezi pchody
  }
  public: Generator() { Activate(); } // konstruktor aktivuje
};

int main() {
  SetOutput("model5.out");
  Print(" MODEL5 - test SIMLIB\n");
  Init(0,1000);              // inicializace experimentu, as bude 0..1000
  Box[0].SetName("Box[0]");
  Box[1].SetName("Box[1]");
  new Generator;             // genertor zkaznk
  Run();                     // simulace
  Box[0].Output();           // tisk vsledk
  Box[1].Output();
  InQueue.Output();
  Tabulka.Output();
  SIMLIB_statistics.Output();     // print run statistics
}

//
