////////////////////////////////////////////////////////////////////////////
// Model multiexp                  SIMLIB/C++
//
// More experiments using various parameters
//

#include "simlib.h"

const double ENDTime = 2000;      // total time of simulation

// model objects:
Facility  Box("Linka");
Histogram Tabulka("Tabulka",0,25,20);


class Zakaznik : public Process { // popis tdy zkaznk
  double Prichod;                 // atribut kadho zkaznka
  void Behavior() {               // --- popis chovn zkaznka ---
    Prichod = Time;               // as pchodu zkaznka
    Seize(Box);                   // obsazen zazen Box
    Wait(10);                     // obsluha
    Release(Box);                 // uvolnn
    Tabulka(Time-Prichod);        // doba obsluhy a ekn
  }
 public:
  Zakaznik() { Activate(); }
};

class Generator : public Event {  // genertor zkaznk
  double dt;
  void Behavior() {               // --- popis chovn genertoru ---
    new Zakaznik;                    // nov zkaznk, aktivace
    Activate(Time+Exponential(dt));  // interval mezi pchody
  }
 public:
  Generator(double d) : dt(d) { Activate(); }
};

void Sample() {
   if(Time>0) Print(" %g", Tabulka.stat.MeanValue());
}
Sampler s(Sample,500);

int main() {
  SetOutput("multiexp.dat");    // pesmrovn vstupu
  Print("# MULTIEXP --- test vce experiment (as=%g) \n", ENDTime);
  for(int i=1; i<=20; i++)  {
    Print("# Experiment#%d \n", i);
    Init(0,ENDTime);            // inicializace, as bude 0..ENDTime
    Box.Clear();                // zde musme inicializovat vechny objekty
    Tabulka.Clear();
    double interval = i;
    new Generator(interval);    // genertor zkaznk, aktivuje se
    Print("%g ", interval);
    Run();                      // jeden simulan experiment
    Print(" %g\n", Tabulka.stat.MeanValue());
    SIMLIB_statistics.Output();     // print run statistics
  }
}

//
