////////////////////////////////////////////////////////////////////////////
// druzice.cc -- pouit knihovny SIMLIB pro spojitou simulaci 3D
//
// (c) PerPet 1997

#include "simlib.h"
#include "simlib3D.h"

typedef Value3D Position, Speed, Force;

const double gravity_constant = 6.67e-11; // gravitan konstanta

const double   m0 = 1000;           // hmotnost druice
const double   m1 = 5.983e24;       // hmotnost Zem
const double   m2 = 7.374e22;       // hmotnost Msce
const Position p0(36.0e6, 0, 0);    // poloha druice
const Position p2(384.405e6, 0, 0); // poloha Msce
//const Speed    v0(0, 4200, 1700);   // poten rychlost druice
const Speed    v0(0, 4200, 1600);   // poten rychlost druice
const Speed    v2(0, 1022, 0);      // obn rychlost Msce
const double   MAXTime=3.6e7;       // doba simulace

Constant3D Zero(0,0,0); // pomocn objekt

////////////////////////////////////////////////////////////////////////////
struct MassPoint {
  double m;              // hmotnost
  Expression3D inforce;  // vstupn sla
  Integrator3D v;        // rychlost
  Integrator3D p;        // poloha
  MassPoint(const double mass, Position p0, Speed v0=Speed(0,0,0)) :
    m(mass), 
    inforce(Zero),
    v(inforce/m, v0), 
    p(v,p0) {}
   void SetInput(Input3D i) { inforce.SetInput(i); }
};


////////////////////////////////////////////////////////////////////////////
struct MyWorld {
  enum { MAX=10 };
  MassPoint *m[MAX];
  unsigned n;
  MyWorld();
  Position Mcenter() {               // vpoet tit systmu
    Position p = Value3D(0,0,0);
    double sum = 0;
    for(unsigned int i=0; i<n; i++) {
      p = p + m[i]->m * m[i]->p.Value();
      sum += m[i]->m;
    }
    return p/sum; 
  }
};

MyWorld *w; // vznikne a pozdji :-)

////////////////////////////////////////////////////////////////////////////
// gravitan sla pusobc na hmotn bod p
//
class GravityForce : public aContiBlock3D {
  MassPoint *p;
  MyWorld *w;
 public:
  GravityForce(MassPoint *_p, MyWorld *_w) : p(_p), w(_w) {} 
  Force Value() {
    Force f(0,0,0);  // gravitan sla
    for(unsigned int i=0; i < w->n; i++) {
      MassPoint *m = w->m[i];
      if (m == p) continue;
      Value3D distance = m->p.Value() - p->p.Value(); 
      double d = abs(distance);  // vzdlenost
      f = f + (distance * gravity_constant * p->m * m->m / (d*d*d)) ; 
    }
    return f; 
  }
};

////////////////////////////////////////////////////////////////////////////
// pohybliv planety
//
typedef MassPoint Planet, Satelite;

MyWorld::MyWorld() {  // vytvome digitln svt
  n=0;
  m[n++] = new Planet(m1,Position(0,0,0),Speed(0,0,0));
  m[n++] = new Planet(m2,p2,v2);
  m[n++] = new Satelite(m0,p0,v0);
  for(unsigned int i=0; i<n; i++)         // zapneme silov psoben
    m[i]->SetInput(new GravityForce(m[i],this));
}

////////////////////////////////////////////////////////////////////////////
// sledovn stavu modelu ...
//
void Sample();
Sampler s(Sample,3600);  // vzorkovn stavu modelu
void Sample() {
  Position t  = w->Mcenter();  // tit systmu
  Position p  = (w->m[2])->p.Value() - t;
  Position p1 = (w->m[1])->p.Value() - t;
  Print("%g ", Time);
  Print("%g %g %g ", p1.x()/1e6, p1.y()/1e6, p1.z()/1e6);
  Print("%g %g %g ", p.x()/1e6,  p.y()/1e6,  p.z()/1e6);
  Print("\n");
}

////////////////////////////////////////////////////////////////////////////
// popis experimentu ...
//
int main()
{
  w = new MyWorld;
  Print("# Model obhu druice kolem soustavy Zem-Msc \n");
  Init(0, 100000);                // inicializace experimentu
  SetMethod("abm4");
  SetStep(1,50);                  // krok
  SetAccuracy(1e-5);              // pro test nen nutn vysok pesnost
  Run();                          // simulace
  return 0;
}

////////////////////////////////////////////////////////////////////////////
