/*
 * Decompiled with CFR 0.152.
 */
package mefe;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import mefe.BehaviorTableKeyAdapter;
import mefe.BehaviorTableMouseAdapter;
import mefe.FuzzyClass;
import mefe.MemberFunction;

public class BehaviorTable
extends JScrollPane {
    BehaviorTableModel btm = new BehaviorTableModel();
    JTable table = new JTable(this.btm);
    int oldx = 0;
    int oldy = 0;

    public BehaviorTable() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        JLabel l = new JLabel("\u0159");
        this.table.getTableHeader().setFont(l.getFont());
        this.table.setFont(l.getFont());
        this.table.setRowSelectionAllowed(false);
        this.table.setColumnSelectionAllowed(false);
        this.table.setCellSelectionEnabled(false);
        this.table.addMouseListener(new BehaviorTableMouseAdapter(this));
        this.table.addKeyListener(new BehaviorTableKeyAdapter(this));
        this.setUpFirstColumnRenderer(this.table);
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                BehaviorTable.this.this_componentResized(e);
            }
        });
        this.getViewport().add((Component)this.table, null);
    }

    private void setUpFirstColumnRenderer(JTable table) {
        table.setDefaultRenderer(Class.forName("mefe.BehaviorTable$MyString"), new FirstColumnRenderer(null, this.getBackground(), this.getForeground()));
    }

    void mouseClicked(MouseEvent e) {
        if (this.oldx != this.table.getSelectedColumn() || this.oldy != this.table.getSelectedRow()) {
            this.oldx = this.table.getSelectedColumn();
            this.oldy = this.table.getSelectedRow();
            return;
        }
        if ((e.getModifiers() & 0x10) == 16) {
            this.btm.incrementGridAt(this.table.getSelectedRow(), this.table.getSelectedColumn());
        } else if ((e.getModifiers() & 4) == 4) {
            this.btm.decrementGridAt(this.table.getSelectedRow(), this.table.getSelectedColumn());
        } else {
            return;
        }
    }

    void keyPressed(KeyEvent e) {
        if (e.getKeyChar() == '+' || e.getKeyChar() == ' ') {
            this.btm.incrementGridAt(this.table.getSelectedRow(), this.table.getSelectedColumn());
        } else if (e.getKeyChar() == '-') {
            this.btm.decrementGridAt(this.table.getSelectedRow(), this.table.getSelectedColumn());
        } else {
            return;
        }
    }

    void this_componentResized(ComponentEvent e) {
        if (this.table.getRowCount() == 0) {
            return;
        }
        Dimension d = null;
        d = this.getSize(d);
        int newHeight = (d.height - 24) / this.table.getRowCount();
        if (newHeight >= 16) {
            this.table.setRowHeight(newHeight);
        } else {
            this.table.setRowHeight(16);
        }
    }

    public void setFunctions(Vector in1, Vector in2, Vector out) {
        this.btm.setFunctions(in1, in2, out);
        this.table = new JTable(this.btm);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.this_componentResized(new ComponentEvent(this, 101));
    }

    public int[][] getGrid() {
        return this.btm.getGrid();
    }

    public void importFromFuzzyClass(FuzzyClass fc) throws Exception {
        this.btm.setGrid(fc.getGrid());
        this.table = new JTable(this.btm);
        try {
            this.jbInit();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class BehaviorTableModel
    extends AbstractTableModel {
        int[][] grid = null;
        String[] columnNames;
        MyString[] rowNames;
        Vector out = null;

        BehaviorTableModel() {
        }

        public void setFunctions(Vector in1, Vector in2, Vector out) {
            int i;
            this.out = out;
            if (this.grid == null) {
                this.grid = new int[in1.size()][in2.size()];
            } else if (this.grid[0].length != in2.size() || this.grid.length != in1.size()) {
                this.grid = new int[in1.size()][in2.size()];
            }
            this.columnNames = new String[in1.size() + 1];
            this.rowNames = new MyString[in2.size()];
            this.columnNames[0] = "";
            for (i = 1; i < this.columnNames.length; ++i) {
                this.columnNames[i] = ((MemberFunction)in1.elementAt(i - 1)).getName();
            }
            for (i = 0; i < this.rowNames.length; ++i) {
                this.rowNames[i] = new MyString(null, ((MemberFunction)in2.elementAt(i)).getName());
            }
            this.fireTableDataChanged();
        }

        public void setGrid(int[][] grid) throws Exception {
            if (this.out == null) {
                throw new Exception("Nemohu nastavit grid, kdy\u017e nejsou nastaveny vektory funkc\u00ed.");
            }
            this.grid = grid;
            this.fireTableDataChanged();
        }

        public int[][] getGrid() {
            return this.grid;
        }

        public void incrementGridAt(int row, int column) {
            if (row < 0 || --column < 0) {
                return;
            }
            int[] nArray = this.grid[column];
            int n = row;
            nArray[n] = nArray[n] + 1;
            int[] nArray2 = this.grid[column];
            int n2 = row;
            nArray2[n2] = nArray2[n2] % this.out.size();
            this.fireTableCellUpdated(row, column + 1);
        }

        public void decrementGridAt(int row, int column) {
            if (row < 0 || --column < 0) {
                return;
            }
            int[] nArray = this.grid[column];
            int n = row;
            nArray[n] = nArray[n] + (this.out.size() - 1);
            int[] nArray2 = this.grid[column];
            int n2 = row;
            nArray2[n2] = nArray2[n2] % this.out.size();
            this.fireTableCellUpdated(row, column + 1);
        }

        public int getRowCount() {
            if (this.rowNames == null) {
                return 0;
            }
            return this.rowNames.length;
        }

        public int getColumnCount() {
            if (this.columnNames == null) {
                return 0;
            }
            return this.columnNames.length;
        }

        public Object getValueAt(int row, int column) {
            if (this.grid == null) {
                return "Null";
            }
            if (column == 0) {
                return this.rowNames[row];
            }
            return String.valueOf(" ").concat(String.valueOf(((MemberFunction)this.out.elementAt(this.grid[column - 1][row])).getName()));
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        public String getColumnName(int col) {
            return this.columnNames[col];
        }
    }

    class FirstColumnRenderer
    extends JLabel
    implements TableCellRenderer {
        public FirstColumnRenderer(BehaviorTable this$0, Color background, Color foreground) {
            this.setBackground(background);
            this.setForeground(foreground);
            this.setBorder(BorderFactory.createBevelBorder(0, Color.white, Color.gray));
            this.setHorizontalAlignment(0);
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object text, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setText(((MyString)text).toString());
            return this;
        }
    }

    class MyString {
        String value;

        public MyString(BehaviorTable this$0, String s) {
            this.value = s;
        }

        public String toString() {
            return this.value;
        }
    }
}

