/*
 * Decompiled with CFR 0.152.
 */
package mefe;

import java.awt.Graphics;
import mefe.MFPaint;
import mefe.MemberFunction;

public class MFTriangle
extends MemberFunction {
    double min = 0.0;
    double max = 0.0;
    double vertex = 0.0;

    public MFTriangle() {
    }

    public MFTriangle(MFPaint p, String name, double min, double vertex, double max) {
        this.parent = p;
        this.setMin(min);
        this.setMax(max);
        this.setVertex(vertex);
        this.setName(name);
        this.values = 3;
    }

    public void setMin(double x) {
        this.min = x;
        if (this.vertex < this.min) {
            this.vertex = this.min;
        }
        if (this.max < this.min) {
            this.max = this.min;
        }
    }

    public void setMax(double x) {
        this.max = x;
        if (this.vertex > this.max) {
            this.vertex = this.max;
        }
        if (this.min > this.max) {
            this.min = this.max;
        }
    }

    public void setVertex(double x) {
        this.vertex = x;
        if (this.min > this.vertex) {
            this.min = this.vertex;
        }
        if (this.max < this.vertex) {
            this.max = this.vertex;
        }
    }

    public double getVertex() {
        return this.vertex;
    }

    public double getMin() {
        return this.min;
    }

    public double getMax() {
        return this.max;
    }

    public double getValue(double x) {
        if (x <= this.min || x >= this.max) {
            return 0.0;
        }
        if (x <= this.vertex) {
            return (x - this.min) / (this.vertex - this.min);
        }
        return (this.max - x) / (this.max - this.vertex);
    }

    public double getValue(int x) {
        return this.getValue(this.parent.mousePosToXValue(x));
    }

    public void paint(Graphics g) {
        double K = (double)(this.parent.getMaxX() - this.parent.getMinX()) / (this.parent.getMax() - this.parent.getMin());
        g.drawLine(this.parent.getMinX() + (int)((this.min - this.parent.getMin()) * K), this.parent.getMaxY(), this.parent.getMinX() + (int)((this.vertex - this.parent.getMin()) * K), this.parent.getMinY());
        g.drawLine(this.parent.getMinX() + (int)((this.vertex - this.parent.getMin()) * K), this.parent.getMinY(), this.parent.getMinX() + (int)((this.max - this.parent.getMin()) * K), this.parent.getMaxY());
    }

    public boolean isEqual(MemberFunction mf) {
        if (mf.getType() == this.getType()) {
            MFTriangle m = (MFTriangle)mf;
            return this.name.equals(m.name) && this.min == m.min && this.max == m.max && this.vertex == m.vertex;
        }
        return false;
    }

    public int getType() {
        return 0;
    }

    public void modifyAll(MemberFunction mf) {
        if (mf.getType() != 0) {
            return;
        }
        this.setMin(((MFTriangle)mf).min);
        this.setVertex(((MFTriangle)mf).vertex);
        this.setMax(((MFTriangle)mf).max);
        this.setName(mf.getName());
        this.values = mf.values;
    }

    public double getMeanValue() {
        return (this.min + this.max) / (double)2 - (this.min + this.max - (double)2 * this.vertex) / (double)2 * MemberFunction.SQRT2;
    }

    public void addDefValue(double value) {
        switch (this.values) {
            case 0: {
                this.setMin(value);
                ++this.values;
                break;
            }
            case 1: {
                this.setVertex(value);
                ++this.values;
                break;
            }
            case 2: {
                this.setMax(value);
                ++this.values;
                break;
            }
        }
    }

    public boolean isComplete() {
        return this.values == 3;
    }

    public int getNumValues() {
        return 3;
    }

    public double getDefValue(int index) {
        switch (index) {
            case 0: {
                return this.min;
            }
            case 1: {
                return this.vertex;
            }
            case 2: {
                return this.max;
            }
        }
        return 0.0;
    }

    public String toString() {
        return String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("FuzzyTriangle(\"").concat(String.valueOf(this.name))).concat(String.valueOf("\", "))).concat(String.valueOf(this.min))).concat(String.valueOf(", "))).concat(String.valueOf(this.vertex))).concat(String.valueOf(", "))).concat(String.valueOf(this.max))).concat(String.valueOf(")"));
    }
}

