/*
 * Decompiled with CFR 0.152.
 */
package mefe.xml;

import mefe.FuzzyClass;
import mefe.FuzzyType;
import mefe.FuzzyVendor;
import mefe.MFFactory;
import mefe.MemberFunction;
import mefe.xml.ErrorReporter;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.helpers.LocatorImpl;

public class FuzzyHandler
extends DefaultHandler
implements FuzzyVendor,
ErrorReporter {
    FuzzyClass fuzzyClass;
    FuzzyType fuzzyType;
    MemberFunction memberFunction;
    boolean isClass;
    int numSets;
    private String sErrors;
    private String sWarnings;
    private String sFatalErrors;
    private int errors;
    private int warnings;
    private int fatalErrors;
    Locator locator = new LocatorImpl();

    public FuzzyClass getFuzzyClass() {
        return this.fuzzyClass;
    }

    public FuzzyType getFuzzyType() {
        return this.fuzzyType;
    }

    public boolean isClassRead() {
        return this.fuzzyClass != null;
    }

    public boolean isTypeRead() {
        return this.fuzzyType != null;
    }

    public void startDocument() {
        this.fuzzyClass = null;
        this.fuzzyType = null;
        this.memberFunction = null;
        this.isClass = false;
        this.numSets = 0;
        this.fatalErrors = 0;
        this.errors = 0;
        this.warnings = 0;
        this.sWarnings = "";
        this.sErrors = "";
        this.sFatalErrors = "";
    }

    public void startElement(String uri, String local, String raw, Attributes attrs) throws SAXParseException {
        if (local.equals("fuzzyclass")) {
            this.isClass = true;
            this.fuzzyClass = new FuzzyClass();
            this.fuzzyClass.setName(attrs.getValue("classname"));
        } else if (local.equals("fuzzytype")) {
            if (++this.numSets >= 4) {
                SAXParseException spe = new SAXParseException("Too much fuzzytype elements. For this implementation is only 3 possible.", this.locator);
                this.fatalError(spe);
                throw spe;
            }
            this.fuzzyType = new FuzzyType();
            this.fuzzyType.setName(attrs.getValue("typename"));
            try {
                double val = Double.valueOf(attrs.getValue("minrange"));
                this.fuzzyType.setMinRange(val);
                val = Double.valueOf(attrs.getValue("maxrange"));
                this.fuzzyType.setMaxRange(val);
            }
            catch (NumberFormatException nfe) {
                SAXParseException spe = new SAXParseException("Double format of number expected.", this.locator);
                this.error(spe);
                throw spe;
            }
        } else if (local.equals("fuzzymf")) {
            this.memberFunction = MFFactory.create(attrs.getValue("mftype"));
            this.memberFunction.setName(attrs.getValue("wordvalue"));
        } else if (local.equals("value")) {
            try {
                double val = Double.valueOf(attrs.getValue("value"));
                this.memberFunction.addDefValue(val);
            }
            catch (NumberFormatException nfe) {
                SAXParseException spe = new SAXParseException("Double format of number expected.", this.locator);
                this.error(spe);
                throw spe;
            }
        } else if (local.equals("outvalue")) {
            if (this.fuzzyClass.types[2].hasWordValue(attrs.getValue("value"))) {
                this.fuzzyClass.addGridValue(this.fuzzyClass.types[2].wordValueToIndex(attrs.getValue("value")));
            } else {
                SAXParseException spe = new SAXParseException(String.valueOf(String.valueOf("Word value (").concat(String.valueOf(attrs.getValue("value")))).concat(String.valueOf(") is not previously defined.")), this.locator);
                this.fatalError(spe);
                throw spe;
            }
        }
    }

    public void endElement(String uri, String local, String qName) throws SAXParseException {
        if (local.equals("fuzzytype")) {
            if (this.isClass) {
                this.fuzzyClass.addType(this.fuzzyType);
            }
        } else if (local.equals("fuzzymf")) {
            if (!this.memberFunction.isComplete()) {
                SAXParseException spe = new SAXParseException(String.valueOf(String.valueOf("Membership function (").concat(String.valueOf(this.memberFunction.getName()))).concat(String.valueOf(") is not complete.")), this.locator);
                this.fatalError(spe);
                throw spe;
            }
            this.fuzzyType.addFunction(this.memberFunction);
        } else if (local.equals("row")) {
            if (!this.fuzzyClass.isBehaviorRowComplete()) {
                SAXParseException spe = new SAXParseException("Row is incomplete.", this.locator);
                this.fatalError(spe);
                throw spe;
            }
        } else if (local.equals("behavior") && !this.fuzzyClass.isBehaviorComplete()) {
            SAXParseException spe = new SAXParseException("Behavior is incomplete.", this.locator);
            this.fatalError(spe);
            throw spe;
        }
    }

    public void characters(char[] ch, int start, int length) {
    }

    public void ignorableWhitespace(char[] ch, int start, int length) {
    }

    public void warning(SAXParseException ex) {
        this.sWarnings = String.valueOf(this.sWarnings).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[Warning] ").concat(String.valueOf(this.getLocationString(ex)))).concat(String.valueOf(": "))).concat(String.valueOf(ex.getMessage()))).concat(String.valueOf("\n"))));
        ++this.warnings;
    }

    public void error(SAXParseException ex) {
        this.sErrors = String.valueOf(this.sErrors).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("[Error] ").concat(String.valueOf(this.getLocationString(ex)))).concat(String.valueOf(": "))).concat(String.valueOf(ex.getMessage()))).concat(String.valueOf("\n"))));
        ++this.errors;
    }

    public void fatalError(SAXParseException ex) {
        this.sFatalErrors = String.valueOf(this.sFatalErrors).concat(String.valueOf(String.valueOf(String.valueOf(String.valueOf(String.valueOf("Fatal Error] ").concat(String.valueOf(this.getLocationString(ex)))).concat(String.valueOf(": "))).concat(String.valueOf(ex.getMessage()))).concat(String.valueOf("\n"))));
        ++this.fatalErrors;
    }

    private String getLocationString(SAXParseException ex) {
        StringBuffer str = new StringBuffer();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(" Line:");
        str.append(ex.getLineNumber());
        str.append(" Column:");
        str.append(ex.getColumnNumber());
        return str.toString();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public int getNumErrors() {
        return this.errors;
    }

    public int getNumWarnings() {
        return this.warnings;
    }

    public int getNumFatalErrors() {
        return this.fatalErrors;
    }

    public boolean isErrorOrWarning() {
        return this.errors + this.warnings + this.fatalErrors > 0;
    }

    public String getErrorMessages() {
        return this.sErrors;
    }

    public String getWarningMessages() {
        return this.sWarnings;
    }

    public String getFatalErrorMessages() {
        return this.sFatalErrors;
    }
}

