////////////////////////////////////////////////////////////////////////////
// Model TestSemaphore.CPP 
//
// Example of queuing system using semaphore (the same as examples/model2.cc)

#include "simlib.h"

Semaphore Box2("Linka2");
Queue Q;
Histogram Tabulka("Tabulka",0,25,20);

class Zakaznik2 : public Process { // tda zkaznk
  double Prichod;                 // atribut kadho zkaznka
  void Behavior() {               // --- popis chovn zkaznka ---
    Prichod = Time;               // as pchodu zkaznka
    Box2.P();                     // obsazen zazen Box
    Wait(10);                     // obsluha
    Box2.V();                     // uvolnn
    Tabulka(Time-Prichod);        // doba obsluhy a ekn
  }
};

class Generator : public Event {  // genertor zkaznk
  void Behavior() {               // --- popis chovn genertoru ---
    (new Zakaznik2)->Activate();  // nov zkaznk, aktivace
    Activate(Time+Exponential(1e3/150));  // interval mezi pchody
  }
};

int main() {                 // popis experimentu s modelem
  Print("Semaphore test\n");
  Init(0,1000);              // inicializace experimentu, as bude 0..1000
  (new Generator)->Activate(); // genertor zkaznk, jeho aktivace
  Run();                     // simulace
  Box2.Output();
  Tabulka.Output();
}

// end
