package main;
/***
 * Lfd comparator
 * Author: Lukas Durfina, idurfina@fit.vutbr.cz
 ***/


import grammar.LfdLexer;
import grammar.LfdParser;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;

import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonToken;
import org.antlr.v4.runtime.CommonTokenFactory;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.UnbufferedCharStream;
import org.antlr.v4.runtime.UnbufferedTokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

import comparators.LfdFunctionComparator;


public class LfdComparator {
	
	private static final boolean ENABLE_DEBUG = true;
	
	
	private static HashMap<String, LfdFunction> _functions1;
	private static HashMap<String, LfdFunction> _functions2;
	
	public static HashMap<String, LfdFunction> getFunctions1() {
		return _functions1;
	}

	
	public static HashMap<String, LfdFunction> getFunctions2() {
		return _functions2;
	}

	public static void main(String[] args) throws Exception {
       
		String inputFile1 = null, inputFile2 = null;
		
		if (args.length == 2) {
			inputFile1 = args[0];
			inputFile2 = args[1];
		}
		else {
			System.err.println("Error: wrong number of arguments");
			return;
		}
        
		InputStream is1 = null, is2 = null;
		if (inputFile1 != null || inputFile2 != null) {
			try {
				is1 = new FileInputStream(inputFile1);
				is2 = new FileInputStream(inputFile2);
			}
			catch (Exception e) {
				System.err.println("Failed to open input file(s)");
				return;
			}
		}

		CharStream input1 = new UnbufferedCharStream(is1);
		LfdLexer lex1 = new LfdLexer(input1);
		CharStream input2 = new UnbufferedCharStream(is2);
		LfdLexer lex2 = new LfdLexer(input2);
        
		// copy text out of sliding buffer and store in tokens
		lex1.setTokenFactory(new CommonTokenFactory(true));
		lex2.setTokenFactory(new CommonTokenFactory(true));
		
		TokenStream tokens1 = new UnbufferedTokenStream<CommonToken>(lex1);
		TokenStream tokens2 = new UnbufferedTokenStream<CommonToken>(lex2);
		LfdParser parser1 = new LfdParser(tokens1);
		LfdParser parser2 = new LfdParser(tokens2);
		//parser.setBuildParseTree(true);

		ParseTree tree1 = parser1.file();
		ParseTree tree2 = parser2.file();

		debug("Tree 1:");
		ParseTreeWalker walker = new ParseTreeWalker();
		LfdWalker lfdWalker1 = new LfdWalker(); 
        walker.walk(lfdWalker1, tree1);
		
		debug("\nTree 2:");
		LfdWalker lfdWalker2 = new LfdWalker(); 
        walker.walk(lfdWalker2, tree2);
        
        // now we can get complete info from walkers and compare it
        // if both info contain main() we use ComparatorWithMain, otherwise ComparatorWithoutMain
        compare(lfdWalker1, lfdWalker2);
    }
	
	
	public static void error(String msg) {
		System.out.println("ERROR: " + msg);
		// TODO
		// should we quit / throw exception ?
	}
	
	/**
	 * Debug print
	 */
	public static void debug(String msg) {
		if (ENABLE_DEBUG) {
			System.out.println("DEBUG: " + msg);
		}
	}
	
	public static void debug(String msg, boolean force) {
		if (ENABLE_DEBUG || force) {
			System.out.println("DEBUG: " + msg);
		}
	}
	
	/**
	 * Compare and print result in %
	 * @param walker1
	 * @param walker2
	 */
	private static void compare(LfdWalker walker1, LfdWalker walker2) {
		double similarity = 0.0;
		
		_functions1 = walker1.getFunctions();
		_functions2 = walker2.getFunctions();
		
		if (_functions1.containsKey("main") && _functions2.containsKey("main")) {
			LfdFunctionComparator cmp = new LfdFunctionComparator();
			
			similarity = cmp.compare(_functions1.get("main"), _functions2.get("main"));
		}
		else {
			// TODO
			similarity = 0.99;
		}
		
		if (similarity > 100.0) {
			similarity = 100;
		}
		
		System.out.format("%nSIMILARITY: %.1f %%%n", similarity);
	}


}

