/***
 * LfdFunctionCall
 * Author: Lukas Durfina, idurfina@fit.vutbr.cz
 ***/


package main;

import java.util.*;
import comparators.IComparable;

/**
 * Class represent a call of function
 */
public class LfdFunctionCall implements IComparable, IStatement {
	
	
	public LfdFunctionCall(LfdFunction f) {
		_calledFunction = f;
	}
	
	/**
	 * Called function
	 */
	private LfdFunction _calledFunction;
	
	public LfdFunction getCalledFunction() { return _calledFunction; }
	
	/**
	 * Used constant argument for call
	 */
	private Vector<String> _arguments = new Vector<String>();
	
	
	public Vector<String> getArguments() {
		return _arguments;
	}
	
	public void addArgument(String arg) {
		_arguments.add(arg);
	}
	
	
	/**
	 * Debug print with arguments
	 */
	public void printArguments() {
		boolean printed = _arguments.size() > 0;
		
		if (printed) {
			System.out.print(_calledFunction.name + ": ");
		}
		
		for (int i = 0; i < _arguments.size(); ++i) {
			printed = true;
			System.out.print(_arguments.elementAt(i) + ", ");
		}
		
		if (printed) {
			System.out.println("");
		}
	}
	
}