/***
 * SimilarLinkedFunctions
 * Load prepared sets of similar functions
 * Author: Lukas Durfina, idurfina@fit.vutbr.cz
 ***/

package main;

import java.util.*;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;

/**
 * TODO this has to be a singleton
 * @author lukasdurfina
 *
 */
public class SimilarLinkedFunctions {
	
	
	public SimilarLinkedFunctions() {
		loadFiles();
	}
	
	
	/**
	 * Map with similar functions.
	 * first: name of functions
	 * second: id of set
	 * Functions with same id belong to same similarity set
	 */
	private HashMap<String, Integer> _similaritySets = new HashMap<String, Integer>();
	
	/**
	 * Check if functions are from same similarity set
	 */
	public boolean areSimilarFunctions(LfdFunction func1, LfdFunction func2) {
		Integer sim1 = _similaritySets.get(func1.name);
		Integer sim2 = _similaritySets.get(func2.name);
		if (sim1 != null && sim1 == sim2) {
			return true;
		}
		return false;
	}
	
	
	/**
	 * Load files to create internal information about similar functions.
	 * Files are stored in directory function_sets.
	 * In each file there is a one function per line
	 */
	private void loadFiles() {
		File file = new File("function_sets");

        // Reading directory contents
        File[] files = file.listFiles();

        for (int i = 0; i < files.length; i++) {
            BufferedReader reader = null;

            try {
                reader = new BufferedReader(new FileReader(files[i]));
                String functionName = null;

                while (true) {
                	functionName = reader.readLine();
                    if (functionName == null) {
                        break;
                    }
                    
                    _similaritySets.put(functionName, i);
                }
            } catch(Exception e) {
                e.printStackTrace();
            } finally {
                if (reader != null) {
                    try {
                        reader.close();
                    } catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
	}
	
}