#pragma once

#include <opencv2/calib3d/calib3d.hpp>
#include <opencv2/video/tracking.hpp>
#include "TrackContainer.h"

using namespace std; 
using namespace cv;

namespace Motion {


class KeyVolumeExtractor;


class TrackMatcher {
private:
	void setVolumeExtractor(KeyVolumeExtractor *volumeExtractor);
	void unsetVolumeExtractor();

protected:
	KeyVolumeExtractor *volumeExtractor;
	
	int getTrackMatched(Track & track);
	void setTrackMatched(Track & track, int matched);

public:
	TrackMatcher();
	virtual void match(TrackContainer & currentTracks, const TrackContainer & detectedTracks, const Mat & currentFrame, const Mat & prevFrame) = 0;

friend class MotionSegmentator;
};


typedef Ptr<TrackMatcher> TrackMatcherPtr;


class BaseTrackMatcher : public TrackMatcher {
protected:
	bool useNcc;
	bool useRansac;
	float minNcc;
	float maxDist;
	float ransacThreshold;

	void ransacOutliers(TrackContainer & currentTracks);

public:
	BaseTrackMatcher(float maxDist = 0.0, float minNcc = 0.0, float ransacThreshold = -1.0);
	void setMaxDistance(float maxDist = 0.0);
	void setMinNcc(float minNcc = 0.0);
	void setRansacThreshold(float threshold = -1.0);
};


class OpticalFlowMatcher : public BaseTrackMatcher {

public:
	OpticalFlowMatcher(float maxDist = 0.0, float minNcc = 0.0, float ransacThreshold = -1.0);
	void match(TrackContainer & currentTracks, const TrackContainer & detectedTracks, const Mat & currentFrame, const Mat & prevFrame);
};


}