#pragma once

#include "TrackMatcher.h"


using namespace std; 
using namespace cv;


namespace Motion {


class TrackRepairer {
public:
	virtual void repair(TrackContainer & currentTracks, TrackContainer & lostTracks, TrackContainer & newTracks, const Mat & gray, const Mat & prevGray) = 0;
};


typedef Ptr<TrackRepairer> TrackRepairerPtr;


class NoneTrackRepairer : public TrackRepairer {
public:
	void repair(TrackContainer & currentTracks, TrackContainer & lostTracks, TrackContainer & newTracks, const Mat & gray, const Mat & prevGray);
};


class PropagationTrackRepairer : public TrackRepairer {
private:
	static const unsigned int MEDIAN_MAX = 15;

	TrackMatcherPtr matcher;
	unsigned int minLength;
	unsigned int deadLength;
	unsigned int medianSize;

	Point2f arrPts[MEDIAN_MAX];
	float arrDists[MEDIAN_MAX];

	void insertToArray(Point2f arrPts[], float arrDist[], unsigned int size, float dist, Point2f pt);
	bool estimateTranslation(const TrackContainer & tracks, Point2f pos, Point2f & trans);
	bool estimateTranslation2(const Track & track, Point2f & trans);

public:
	PropagationTrackRepairer(TrackMatcherPtr trackMatcher, unsigned int minLength, unsigned int deadLength, unsigned int medianSize);
	void repair(TrackContainer & currentTracks, TrackContainer & lostTracks, TrackContainer & newTracks, const Mat & gray, const Mat & prevGray);
	void setMatcher(TrackMatcherPtr matcher);
	void setMinLength(unsigned int minLength);
	void setDeadLength(unsigned int deadLength);
	void setMedianSize(unsigned int medianSize);
};


class OpticalFlowTrackRepairer : public TrackRepairer {
private:
	static const int MEDIAN_MAX = 15;

	unsigned int minLength;
	unsigned int deadLength;
	unsigned int medianSize;

	Point2f arrPts[MEDIAN_MAX];
	float arrDists[MEDIAN_MAX];

	void insertToArray(Point2f arrPts[], float arrDist[], unsigned int size, float dist, Point2f pt);
	bool estimateTranslation(const TrackContainer & tracks, Point2f pos, Point2f & trans);

public:
	OpticalFlowTrackRepairer(unsigned int minLength, unsigned int deadLength, unsigned int medianSize);
	void repair(TrackContainer & currentTracks, TrackContainer & lostTracks, TrackContainer & newTracks, const Mat & gray, const Mat & prevGray);
	void setMinLength(unsigned int minLength);
	void setDeadLength(unsigned int deadLength);
	void setMedianSize(unsigned int medianSize);
};


}
