#ifndef _SEGMENTS_H
#define _SEGMENTS_H


#include <opencv2/opencv.hpp>
#include "VideoSequence.h"


namespace vmatch {


class Segment {
protected:
	int startRef;
	int startQuery;
	int endRef;
	int endQuery;

public:
	Segment(int startRef, int endRef, int startQuery, int endQuery);
	int getStartRef() const;
	int getStartQuery() const;
	int getEndRef() const;
	int getEndQuery() const;
};


typedef cv::Ptr<Segment> SegmentPtr;


class Segments : public std::vector<SegmentPtr> {
private:
	class CompareSegments {
	public:
		bool operator()(SegmentPtr A, SegmentPtr B) const;
	};

protected:
	VideoSequence::MetaData metaRef;
	VideoSequence::MetaData metaQuery;

public:
	Segments();
	Segments(const VideoSequence::MetaData & metaRef, const VideoSequence::MetaData & metaQuery);
	VideoSequence::MetaData getMetaDataRef() const;
	VideoSequence::MetaData getMetaDataQuery() const;
	void sort();
};


}


#endif
