#include "SegmentsConvertor.h"


namespace vmatch {


FullSegmentsConvertor::FullSegments FullSegmentsConvertor::convert(const Segments & segments) {
	Segments segmentsEnd = segments;
	segmentsEnd.sort();
	segmentsEnd.push_back(new Segment(segments.getMetaDataRef().length, segments.getMetaDataRef().length, segments.getMetaDataQuery().length, segments.getMetaDataQuery().length));
	
	FullSegments segmentsFull;	

	int refStart  = 0;
	int refEnd    = 0;
	int refLength = 0;
	int qryStart  = 0;
	int qryEnd    = 0;	
	int qryLength = 0;

	for(Segments::iterator it = segmentsEnd.begin(); it != segmentsEnd.end(); it++) {
		SegmentPtr segment = *it;
		
		refEnd = segment->getStartRef()-1;
		qryEnd = segment->getStartQuery()-1;

		if(refEnd < refStart) {
			refStart = refEnd = segment->getStartRef();
		}

		if(qryEnd < qryStart) {
			qryStart = qryEnd = segment->getStartQuery();
		}

		refLength = refEnd - refStart;
		qryLength = qryEnd - qryStart;

		if(refLength > 0 || qryLength > 0) {
			FullSegmentPtr gapSegment = new FullSegment(refStart, refEnd, qryStart, qryEnd, false);
			segmentsFull.push_back(gapSegment);
		}

		if(it+1 != segmentsEnd.end()) {
			FullSegmentPtr similarSegment = new FullSegment(*segment);
			segmentsFull.push_back(similarSegment);
		}

		refStart = segment->getEndRef()+1;
		qryStart = segment->getEndQuery()+1;
	}

	return segmentsFull;
}


FullSegmentsConvertor::FullSegment::FullSegment(int startRef, int endRef, int startQuery, int endQuery, bool similar) : Segment(startRef, endRef, startQuery, endQuery) {
	this->similar = similar;
}


FullSegmentsConvertor::FullSegment::FullSegment(const Segment & segment) : Segment(segment.getStartRef(), segment.getEndRef(), segment.getStartQuery(), segment.getEndQuery()) {
	this->similar = true;
}


bool FullSegmentsConvertor::FullSegment::isSimilar() const {
	return similar;
}


FullSegmentsConvertor::FullSegments::FullSegments() : std::vector<FullSegmentPtr>() {
}


}
