#ifndef _VIDEOSEQUENCE_H
#define _VIDEOSEQUENCE_H


#include <opencv2/opencv.hpp>
#include <algorithm>
#include "FrameDescriptorExtractor.h"

#ifdef VTAPI
#include "vtapi.h"
#endif


namespace vmatch {


class VideoSequence {
public:
	class FrameFilter;
	class MetaData;
	typedef cv::Ptr<FrameFilter> FrameFilterPtr;
	typedef cv::Ptr<MetaData> MetaDataPtr;

private:
	FrameDescriptorExtractorPtr extractor;
	FrameFilterPtr filter;
	int frameNumber;

protected:
	MetaDataPtr metaData;
	virtual bool step() = 0;
	virtual void stepToStart() = 0;
	virtual cv::Mat frame() = 0;

public:
	VideoSequence(FrameDescriptorExtractorPtr extractor);	
	bool next();
	void rewind();
	MetaData getMetaData();
	cv::Mat getFrame();
	int getFrameNumber();
	FrameDescriptorPtr getFrameDescriptor();
	FrameDescriptorExtractorPtr getDescriptorExtractor() const;
	void setDescriptorExtractor(FrameDescriptorExtractorPtr extractor);
	FrameFilterPtr getFilter() const;
	void setFilter(FrameFilterPtr filter);
};


typedef cv::Ptr<VideoSequence> VideoSequencePtr;


class VideoSequence::FrameFilter {
public:
	virtual void apply(cv::Mat & frame);
};


class VideoSequence::MetaData {
protected:
	static const std::string NODE_FPS;
	static const std::string NODE_LENGTH;

public:
	static const int UNKNOWN;

	double fps;
	int length;

	MetaData();
	void write(cv::FileStorage & fs) const;
	void read(cv::FileNode & nd);
};


class CvVideoSequence : public VideoSequence {
protected:
	cv::Ptr<cv::VideoCapture> capture;

	virtual bool step();
	void stepToStart();
	virtual cv::Mat frame();

public:
	CvVideoSequence(const std::string & filename, FrameDescriptorExtractorPtr extractor);
    cv::Ptr<cv::VideoCapture> getCapture();
};


#ifdef VTAPI
class VtVideoSequence : public VideoDescriptorSequence {
protected:
	virtual bool step();
	void stepToStart();
	virtual cv::Mat frame();

	Sequence* sequence;

public:
	VtVideoSequence(Sequence* sequence, FrameDescriptorExtractorPtr extractor);
};
#endif


}


#endif
