#include "cvvideoplayer.h"
#include "ui_cvvideoplayer.h"

CvVideoPlayer::CvVideoPlayer(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::CvVideoPlayer)
{
    ui->setupUi(this);

    capture = NULL;
}

CvVideoPlayer::~CvVideoPlayer()
{
    delete ui;
}

void CvVideoPlayer::open(QString filename)
{
    try
    {
        try
        {
            capture = new cv::VideoCapture(filename.toStdString());
        }
        catch(...)
        {
            capture = NULL;
            throw;
        }

        if(!capture->isOpened())
        {
            CV_Error(CV_StsObjectNotFound, "Cannot open video capture.");
        }

        setPosition(0);
    }
    catch(...)
    {
        close();
        throw;
    }
}

void CvVideoPlayer::close()
{
    if(capture != NULL)
    {
        delete capture;
        capture = NULL;
    }
}

int CvVideoPlayer::getPosition() const
{
    if(capture != NULL)
    {
        return (int)capture->get(CV_CAP_PROP_POS_FRAMES);
    }
    else
    {
        return -1;
    }
}

bool CvVideoPlayer::setPosition(int frame)
{
    if(capture != NULL)
    {
        frame = std::min<int>(frame, (int)capture->get(CV_CAP_PROP_FRAME_COUNT)-1);

        capture->set(CV_CAP_PROP_POS_FRAMES, frame);
        while((int)capture->get(CV_CAP_PROP_POS_FRAMES) < frame)
        {
            capture->grab();
        }

        readImage();
        return true;
    }
    return false;
}

bool CvVideoPlayer::next()
{
    if(capture != NULL)
    {
        bool ok = capture->grab();
        readImage();
        return ok;
    }
    else
    {
        return false;
    }
}

void CvVideoPlayer::readImage()
{
    if(capture != NULL)
    {
        cv::Mat frameCv;
        if(capture->read(frameCv))
        {
            frame = matToQimage(frameCv);
            ui->frame->setAlignment(Qt::AlignCenter);
            ui->frame->setPixmap(QPixmap::fromImage(frame).scaled(ui->frame->size(), Qt::KeepAspectRatio, Qt::FastTransformation));
            //repaint();
            return;
        }
    }

    frame = QImage();
    repaint();
}

QImage CvVideoPlayer::matToQimage(cv::Mat & src)
{
    if(src.channels() == 3)
    {
        cv::cvtColor(src, src, CV_BGR2RGB);
    }
    else
    {
        cv::cvtColor(src, src, CV_GRAY2RGB);
    }

    QImage imgQt((uchar *)src.data, src.cols, src.rows, (int)src.step, QImage::Format_RGB888);
    return imgQt.copy();
}

void CvVideoPlayer::resizeEvent(QResizeEvent *e)
{
    Q_UNUSED(e);

    ui->frame->setAlignment(Qt::AlignCenter);
    ui->frame->setPixmap(QPixmap::fromImage(frame).scaled(ui->frame->size(), Qt::KeepAspectRatio, Qt::FastTransformation));
}

