#ifndef SIMILARITYTIMELINE_H
#define SIMILARITYTIMELINE_H

#include <QWidget>
#include <QPainter>
#include <QDebug>
#include <QPaintEvent>
#include <QMouseEvent>
#include <algorithm>
#include <Segments.h>

namespace Ui {
class SimilarityTimeline;
}

class SimilarityTimeline : public QWidget
{
    Q_OBJECT

public:
    typedef enum
    {
        VIEW_REF,
        VIEW_QRY
    } ViewType;

    class Segment {
    public:
        typedef enum
        {
            DIS_INJECTION,
            DIS_REMOVAL,
            DIS_REWRITING,
            MATCH
        } Dissimilarity;

    private:
        int startRef;
        int endRef;
        int startQry;
        int endQry;
        bool matchRef;
        bool matchQry;
        double lengthSecRef;
        double lengthSecQry;
        Dissimilarity dissimilarity;

        static Dissimilarity classifyDissimilarity(double lengthRef, double lengthQry, bool match);

    public:
        Segment(int startRef, int endRef, int startQry, int endQry, bool match, double fpsRef, double fpsQry);
        int getStartRef() const;
        int getEndRef() const;
        int getStartQry() const;
        int getEndQry() const;
        double getLengthSecRef() const;
        double getLengthSecQry() const;
        double getLengthSecMax() const;
        double getLengthFramesRef() const;
        double getLengthFramesQry() const;
        double getLengthFramesMax() const;
        Dissimilarity getDissimilarityType() const;
        bool isMatchRef() const;
        bool isMatchQry() const;
        bool operator<(const Segment & second) const;
    };

    typedef std::vector<Segment> _Segments;

    class Segments : public _Segments {
    public:
        Segments();
        Segments(vmatch::Segments segments);
        bool check() const;
    };

public:
    explicit SimilarityTimeline(QWidget *parent = 0);
    void setSegments(Segments newSegments);
    void clearSegments();
    void setColorMatch(QColor color);
    void setColorInjection(QColor color);
    void setColorRemoval(QColor color);
    void setColorRewriting(QColor color);
    void setHighlightSegments(bool doHighlightSegments);
    void setView(ViewType view);
    void setCursorVisible(bool cursorVisible);
    void setCursorPositionGlobal(double positionGlobal);
    void setCursorPositionSegment(int segmentIdx, double positionSegment);
    ~SimilarityTimeline();

signals:
    void cursorMoved(int segmentIdx, double positionSegment, double positionGlobal);
    void segmentClicked(int segmentIdx, double positionSegment, double positionGlobal);
    
private:
    Ui::SimilarityTimeline *ui;
    Segments segments;
    ViewType viewType;
    QColor colorMatch;
    QColor colorInjection;
    QColor colorRemoval;
    QColor colorRewriting;
    bool highlightSegments;

    double totalLength;
    double scale;

    double cursorPosition;
    bool cursorGrabbed;
    bool cursorVisible;

    void recomputeDimensions();
    double getScale() const;
    bool isSegmentMatchingInCurrentView(const Segment & segment) const;
    bool isCursorNear(int x, int y, int neighbourhood) const;
    int getCursorPositionPx() const;
    int getSegmentIdxByPosition(double position, double *positionInsideSegment = NULL);

    void paintEvent(QPaintEvent *e);
    void paintSegments(QPainter & painter);
    void paintCursor(QPainter & painter);

    void mouseMoveEvent(QMouseEvent *e);
    void mousePressEvent(QMouseEvent *e);
    void mouseReleaseEvent(QMouseEvent *e);
    void mouseClickEvent(QMouseEvent *e);
};

#endif // SIMILARITYTIMELINE_H
