#include "videocontrols.h"
#include "ui_videocontrols.h"

const QString VideoControls::TOOLTIP_PLAY = "Přehrát";
const QString VideoControls::TOOLTIP_STOP = "Zastavit";
const QString VideoControls::TOOLTIP_FORWARDS = "Krok o 1 snímek vpřed";
const QString VideoControls::TOOLTIP_FORWARDS_FAST = "Krok o 10 snímků vpřed";
const QString VideoControls::TOOLTIP_BACKWARDS = "Krok o 1 snímek zpět";
const QString VideoControls::TOOLTIP_BACKWARDS_FAST = "Krok o 10 snímků zpět";
const QString VideoControls::TOOLTIP_GOTO_START = "Krok na začátek segmentu";
const QString VideoControls::TOOLTIP_GOTO_END = "Krok na konec segmentu";

VideoControls::VideoControls(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::VideoControls)
{
    ui->setupUi(this);
    setState(STATE_IDLE);
    setAutoRepeat(true);

    ui->btnPlay->setToolTip(TOOLTIP_PLAY);
    ui->btnGoForwards->setToolTip(TOOLTIP_FORWARDS);
    ui->btnGoForwardsFast->setToolTip(TOOLTIP_FORWARDS_FAST);
    ui->btnGoBackwards->setToolTip(TOOLTIP_BACKWARDS);
    ui->btnGoBackwardsFast->setToolTip(TOOLTIP_BACKWARDS_FAST);
    ui->btnGoToStart->setToolTip(TOOLTIP_GOTO_START);
    ui->btnGoToEnd->setToolTip(TOOLTIP_GOTO_END);
}

VideoControls::~VideoControls()
{
    delete ui;
}

void VideoControls::setAutoRepeatDelay(int delay)
{
    ui->btnGoBackwards->setAutoRepeatDelay(delay);
    ui->btnGoBackwardsFast->setAutoRepeatDelay(delay);
    ui->btnGoForwards->setAutoRepeatDelay(delay);
    ui->btnGoForwardsFast->setAutoRepeatDelay(delay);
}

void VideoControls::setAutoRepeat(bool autoRepeat)
{
    ui->btnGoBackwards->setAutoRepeat(autoRepeat);
    ui->btnGoBackwardsFast->setAutoRepeat(autoRepeat);
    ui->btnGoForwards->setAutoRepeat(autoRepeat);
    ui->btnGoForwardsFast->setAutoRepeat(autoRepeat);
}

VideoControls::State VideoControls::getState() const
{
    return state;
}

void VideoControls::setState(VideoControls::State state)
{
    switch(state)
    {
        case STATE_IDLE:
            setStateIdle();
            break;

        case STATE_PLAYING:
            setStatePlaying();
            break;
    }
}

void VideoControls::setStateIdle()
{
    state = STATE_IDLE;
    ui->btnPlay->setText("►");
    ui->btnPlay->setToolTip(TOOLTIP_PLAY);
}

void VideoControls::setStatePlaying()
{
    state = STATE_PLAYING;
    ui->btnPlay->setText("■");
    ui->btnPlay->setToolTip(TOOLTIP_STOP);
}

void VideoControls::on_btnGoToStart_clicked()
{
    emit goToStart();
}

void VideoControls::on_btnGoBackwardsFast_clicked()
{
    emit goBackwardsFast();
}

void VideoControls::on_btnGoBackwards_clicked()
{
    emit goBackwards();
}

void VideoControls::on_btnPlay_clicked()
{
    switch(state)
    {
        case STATE_IDLE:
            emit play();
            break;

        case STATE_PLAYING:
            emit stop();
            break;
    }
}

void VideoControls::on_btnGoForwards_clicked()
{
    emit goForwards();
}

void VideoControls::on_btnGoForwardsFast_clicked()
{
    emit goForwardsFast();
}

void VideoControls::on_btnGoToEnd_clicked()
{
    emit goToEnd();
}
