#pragma once

#include <vector>
#include <iostream>
#include "Track.h"
#include "Features.h"

using namespace std;
using namespace cv;

namespace Motion {


class TrackContainer : public vector<TrackPtr> {
public:
	class Test;
	class NotMatched;
	class ShorterThan;
	class UpdatedBefore;

	TrackContainer(void);
	TrackContainer(const KeyPoints & keypoints, const Mat & descriptors, int64 timestamp);
	TrackPtr item(unsigned int idx) const;
	void setContent(const KeyPoints & keypoints, const Mat & descriptors, int64 timestamp);
	unsigned int addContent(const TrackContainer & container, double maxDist = 0.0, bool matchedOnly = false);
	TrackContainer removeContent(const Test & test, bool remove = true);
};


class TrackContainer::Test {
public:
	virtual bool keep(const Track & track) const;
};

class TrackContainer::NotMatched : public TrackContainer::Test {
public:
	bool keep(const Track & track) const;
};


class TrackContainer::ShorterThan : public TrackContainer::Test {
	unsigned int minLength;

public:
	bool keep(const Track & track) const;
	ShorterThan(unsigned int minLength);
};


class TrackContainer::UpdatedBefore : public TrackContainer::Test {
	unsigned int maxFramesNotUpdated;

public:
	UpdatedBefore(unsigned int maxFramesNotUpdated);
	bool keep(const Track & track) const;
};


}
