#ifndef _SEGMENTSEXTRACTOR_H
#define _SEGMENTSEXTRACTOR_H


#include <vector>
#include <fstream>
#include "KeyFramesExtractor.h"
#include "SimilarityMatrix.h"
#include "Segments.h"
#include "KeySegments.h"
#include "VideoSequence.h"
#include "VideoSequenceData.h"


namespace vmatch {


class SegmentsExtractor {
protected:
	typedef std::vector<cv::Vec4i> ExtractedSegments;

	// TODO jen na ladeni
	VideoSequenceDataPtr tmpDataRef;
	VideoSequenceDataPtr tmpDataQuery;
	// TODO jen na ladeni

	void convertSegments(ExtractedSegments extractedSegments, VideoSequenceDataPtr dataRef, VideoSequenceDataPtr dataQuery, Segments & segments);
	virtual void extractFunc(const SimilarityMatrix & similarity, VideoSequenceDataPtr dataRef, VideoSequenceDataPtr dataQuery, ExtractedSegments & segments) = 0;

public:
	Segments extract(const SimilarityMatrix & similarity, VideoSequenceDataPtr dataRef, VideoSequenceDataPtr dataQuery);
};


typedef cv::Ptr<SegmentsExtractor> SegmentsExtractorPtr;


class HoughSegmentsExtractor : public SegmentsExtractor {
protected:
	double threshold;

	void preprocessImage(cv::Mat & img) const;
	void detectLines(cv::Mat & img, ExtractedSegments & lines) const;
	bool isNear(int xA, int yA, int xB, int yB, int threshold) const;
	bool isInside(const cv::Vec4i & A, const cv::Vec4i & B, int threshold) const;
	bool isExtension(const cv::Vec4i & A, const cv::Vec4i & B, int threshold) const;
	void removeOrthogonalLines(ExtractedSegments & lines) const;
	void removeSimilarLines(ExtractedSegments & lines) const;
	void removeOverlappingLines(ExtractedSegments & lines) const;
	void mergeLines(ExtractedSegments & lines) const;
	void processLines(ExtractedSegments & lines) const;
	virtual void extractFunc(const SimilarityMatrix & similarity, VideoSequenceDataPtr dataRef, VideoSequenceDataPtr dataQuery, ExtractedSegments & segments);

public:
	HoughSegmentsExtractor(double threshold);
	void setThreshold(double threshold);
};


class SubdivisionSegmentsExtractor : public SegmentsExtractor {
protected:
	double threshold;

	virtual void extractFunc(const SimilarityMatrix & similarity, VideoSequenceDataPtr dataRef, VideoSequenceDataPtr dataQuery, ExtractedSegments & segments);
	void preprocessImage(cv::Mat & img) const;
	void getSegmentLengthMatrix(const cv::Mat & similarityProcessed, cv::Mat & length, cv::Mat & endX, cv::Mat & endY) const;
	bool checkAngle(const cv::Point & start, const cv::Point & end) const;
	cv::Point extendSegment(const cv::Mat & similarityProcessed, const cv::Point & start, int maxGap = 0) const;
	bool findDominantSegment(const cv::Mat & length, const cv::Mat & endX, const cv::Mat & endY, cv::Point & start, cv::Point & end, float minLength) const;
	void recursion(ExtractedSegments & segments, const cv::Mat & length, const cv::Mat & endX, const cv::Mat & endY, const cv::Rect & roi, float minLength, int depth);

public:
	SubdivisionSegmentsExtractor(double threshold);
	void setThreshold(double threshold);
};


class NeedlemanWunschSegmentsExtractor : public SegmentsExtractor {
protected:
	typedef enum {
		TR_DIAGONAL = 1,
		TR_VERTICAL = 2,
		TR_HORIZONTAL = 3
	} TraceDirection;

	typedef std::vector<cv::Point> Points;
	typedef std::vector<Points> PointSegments;

	struct Segment {
		cv::Point start;
		cv::Point end;
		float score;
		Segment(cv::Point start, cv::Point end, float score = 0) {
			this->start = start;
			this->end = end;
			this->score = score;
		}
	};

	typedef std::vector<Segment> Segments;

    double geometricSubdivisionThreshold;
    double similaritySubdivisionThreshold;
    double minSegmentLength;

	virtual void extractFunc(const SimilarityMatrix & similarity, VideoSequenceDataPtr dataRef, VideoSequenceDataPtr dataQuery, ExtractedSegments & segments);
	void findAlignment(const SimilarityMatrix & similarity, double gapWeight, cv::Mat & score, cv::Mat & trace);
	Points backTrace(const cv::Mat & trace);
	int mostDivergingFromSegment(Points & points, double & maxDist);
	double linePointDistance(cv::Point pt, cv::Point lineStart, cv::Point lineEnd);
	void geometricSubdivision(PointSegments & segments, double distThr);
	void similaritySubdivision(PointSegments & segments, SimilarityMatrix & similarityNormalized, double distThr);
	void filterSegments(PointSegments & segments, bool angle = false, double minLength = -1);

public:
	NeedlemanWunschSegmentsExtractor();
    void setGeometricSubdivisionThreshold(double threshold);
    void setSimilaritySubdivisionThreshold(double threshold);
    void setMinSegmentLength(double length);
};


}


#endif
